/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import java.util.Date;

public class Timer {
    long startTime;
    long stopTime;

    public void start() {
        this.startTime = new Date().getTime();
    }

    public void stop() {
        this.stopTime = new Date().getTime();
    }

    public String toString() {
        Elapsed elapsed = new Elapsed(this.startTime, this.stopTime);
        long hrs = elapsed.removeHours();
        long mins = elapsed.removeMinutes();
        long secs = elapsed.removeSeconds();
        long milliseconds = elapsed.removeMilliseconds();
        return String.format("Time elapsed %d hrs %d mins %d sec %d ms", hrs, mins, secs, milliseconds);
    }

    public long millis() {
        long milliseconds = this.stopTime - this.startTime;
        return milliseconds;
    }

    public long seconds() {
        long milliseconds = this.stopTime - this.startTime;
        long secs = milliseconds / 60L;
        return secs;
    }

    public long minutes() {
        long milliseconds = this.stopTime - this.startTime;
        long secs = milliseconds / 60L;
        long mins = secs / 60L;
        return mins;
    }

    private class Elapsed {
        long duration;
        private static final int SECONDS_IN_MS = 1000;
        private static final int MINUTES_IN_MS = 60000;
        private static final int HOURS_IN_MS = 3600000;

        public Elapsed(long startTime, long stopTime) {
            this.duration = stopTime - startTime;
        }

        int removeAmount(long amountInMilliSeconds) {
            long amount = this.duration / amountInMilliSeconds;
            if (amount > 0L) {
                this.duration -= amount * amountInMilliSeconds;
            }
            return (int)amount;
        }

        int removeHours() {
            return this.removeAmount(3600000L);
        }

        int removeMinutes() {
            return this.removeAmount(60000L);
        }

        int removeSeconds() {
            return this.removeAmount(1000L);
        }

        int removeMilliseconds() {
            return this.removeAmount(1L);
        }
    }
}

