package TDS::Tdf::Command::DIARY;
# $Id: DIARY.pm,v 1.3 2000/12/20 14:59:45 tom Exp $
################################################################
use DateTime::Date;
use CGI::QueryString;
use CGI::Tools;
use TDS::System;
use TDS::IdentInfo;
use Template;

use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd @WeekStr $Type $MustHaveContent
	    $TitleTemplate $TitleEndTemplate
	    $CanReverseContent $WithImage
	    $HrefTemplateDynamic $HrefTemplateStatic $DateFormat $Anchor
	    );

@ISA = qw(TDS::Tdf::Command);
$OmittableEnd = 0;
$TitleTemplate = qq(<a href="%href">%year/%0m/%0d</a><ul>\n) unless defined $TitleTemplate;
$TitleEndTemplate = "</ul>" unless defined $TitleEndTemplate;
$MustHaveContent = 1;
$CanReverseContent = 1;
$Type = 'block';
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'New'}},
@AllowCommands = ('%New',
		  'TIMEDIV');
$NumAttr = 3;
$Template = q(<hr><h2><span class="tds-date"><a href="%href" name="%anchor">%date</a></span></h2><dl>) unless defined $Template;
$EndTemplate = "</dl>" unless defined $EndTemplate;
$HrefTemplateDynamic = "./?%date_href\#%anchor" unless defined $HrefTemplateDynamic;
#$HrefTemplateDynamic = "%prefix%date_href\#%anchor";
$HrefTemplateStatic = "d%y%0m%part.%suffix\#%anchor" unless defined $HrefTemplateStatic;
$DateFormat = "%year/%month/%day(%week_holy)" unless defined $DateFormat;
$Anchor = "%0d" unless defined $Anchor;
$WithImage = 0 unless defined $WithImage;

sub SetParams($$)
{
    my ($self, $params) = @_;

    if ($WithImage){
#	my $image = new TDS::Tdf::Command::DAILYIMAGE;
#	$params->{daily_image} = $image->AsHTML($params);

	unless ($params->{daily_image}){
	    my $image = new TDS::Tdf::Command::DAILYIMAGE;
	    $image->AsHTML($params);
	}
    }
    $params->{url} = TDS::IdentInfo->Get("url");
}
	      
sub AsHTML($$)
{
    my ($self, $params) = @_;

    my $date = new DateTime::Date;

    my $day = $self->{attr}->[3];
    chomp $day;
    $date->Set($self->{attr}->[1], $self->{attr}->[2], $day);
    $params = $date->GetParams($params);
    
#    print $date->Dump;
    # դΥեޥåȡ0.01ϤȤθߴ
    $params->{date} = Template::Expand($DateFormat, $params);
    
    # suffix
    ## äɲ
    $params->{year_first} = int($date->year/1000);
    $params->{year_rest} = sprintf("%03d", $date->year%1000);

    if (param('keyword')){
	my $match_num_old = $params->{match}->{num};
	my $html = $self->SUPER::AsHTML($params);
	$params->{match}->{diary}++
	    if $params->{match}->{num} > $match_num_old;
	return $html;
    } else {
	return $self->SUPER::AsHTML($params);
    }
}
sub ResetChildCounter($$)
{
    my ($self, $params) = @_;

    $params->{timediv} = 0;
    $params->{new} = 0;
    $params->{has_secret} = 0;
    $params->{fn} = 0;
    $params->{daily_image} = undef;
}
1;
