/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.albatross;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.islandoftex.albatross.GlyphKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/islandoftex/albatross/Glyph;", "", "codepoints", "", "", "string", "(Ljava/util/List;Ljava/lang/String;)V", "getCodepoints", "()Ljava/util/List;", "getString", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "albatross"})
public final class Glyph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> codepoints;
    @NotNull
    private final String string;

    public Glyph(@NotNull List<String> codepoints, @NotNull String string) {
        Intrinsics.checkNotNullParameter(codepoints, "codepoints");
        Intrinsics.checkNotNullParameter(string, "string");
        this.codepoints = codepoints;
        this.string = string;
    }

    @NotNull
    public final List<String> getCodepoints() {
        return this.codepoints;
    }

    @NotNull
    public final String getString() {
        return this.string;
    }

    @NotNull
    public final List<String> component1() {
        return this.codepoints;
    }

    @NotNull
    public final String component2() {
        return this.string;
    }

    @NotNull
    public final Glyph copy(@NotNull List<String> codepoints, @NotNull String string) {
        Intrinsics.checkNotNullParameter(codepoints, "codepoints");
        Intrinsics.checkNotNullParameter(string, "string");
        return new Glyph(codepoints, string);
    }

    public static /* synthetic */ Glyph copy$default(Glyph glyph, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = glyph.codepoints;
        }
        if ((n & 2) != 0) {
            string = glyph.string;
        }
        return glyph.copy(list, string);
    }

    @NotNull
    public String toString() {
        return "Glyph(codepoints=" + this.codepoints + ", string=" + this.string + ")";
    }

    public int hashCode() {
        int result = ((Object)this.codepoints).hashCode();
        result = result * 31 + this.string.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Glyph)) {
            return false;
        }
        Glyph glyph = (Glyph)other;
        if (!Intrinsics.areEqual(this.codepoints, glyph.codepoints)) {
            return false;
        }
        return Intrinsics.areEqual(this.string, glyph.string);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0006J\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\n2\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/islandoftex/albatross/Glyph$Companion;", "", "()V", "fromCodePointOrNull", "Lorg/islandoftex/albatross/Glyph;", "codepoint", "", "fromStringOrNull", "text", "getGraphemes", "", "albatross"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Glyph fromStringOrNull(@NotNull String text) {
            Glyph glyph;
            List<List<String>> list;
            Intrinsics.checkNotNullParameter(text, "text");
            List<List<String>> it = list = this.getGraphemes(text);
            boolean bl = false;
            List<List<String>> list2 = it.size() == 1 ? list : null;
            if (list2 != null) {
                it = list2;
                boolean bl2 = false;
                glyph = new Glyph(it.get(0), text);
            } else {
                glyph = null;
            }
            return glyph;
        }

        @Nullable
        public final Glyph fromCodePointOrNull(@NotNull String codepoint) {
            Glyph glyph;
            Intrinsics.checkNotNullParameter(codepoint, "codepoint");
            try {
                String string = codepoint.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
                List<String> list = CollectionsKt.listOf(string);
                char[] cArray = Character.toChars(Integer.parseInt(codepoint, CharsKt.checkRadix(16)));
                Intrinsics.checkNotNullExpressionValue(cArray, "toChars(codepoint.toInt(Settings.hexRadix))");
                glyph = new Glyph(list, StringsKt.concatToString(cArray));
            }
            catch (NumberFormatException numberFormatException) {
                glyph = null;
            }
            return glyph;
        }

        /*
         * WARNING - void declaration
         */
        private final List<List<String>> getGraphemes(String text) {
            Object object = BreakIterator.getCharacterInstance();
            BreakIterator it = object;
            boolean bl = false;
            it.setText(text);
            BreakIterator iterator2 = object;
            Object $this$getGraphemes_u24lambda_u244 = object = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator");
            Iterator<IntRange> iterator3 = GlyphKt.iterator(iterator2);
            while (iterator3.hasNext()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                IntRange i = iterator3.next();
                IntStream intStream = StringsKt.substring(text, i).codePoints();
                Intrinsics.checkNotNullExpressionValue(intStream, "text.substring(i).codePoints()");
                Iterable iterable = StreamsKt.toList(intStream);
                Object object2 = $this$getGraphemes_u24lambda_u244;
                boolean $i$f$map = false;
                void var11_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void x;
                    int n = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    String string = Integer.toString((int)x, CharsKt.checkRadix(16));
                    Intrinsics.checkNotNullExpressionValue(string, "toString(this, checkRadix(radix))");
                    String string2 = string.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase(Locale.ROOT)");
                    collection.add(string2);
                }
                object2.add((List)destination$iv$iv);
            }
            return CollectionsKt.build(object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

