/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.defaultsources;

import com.martiansoftware.jsap.DefaultSource;
import com.martiansoftware.jsap.Defaults;
import com.martiansoftware.jsap.ExceptionMap;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.JSAPException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyDefaultSource
implements DefaultSource {
    private boolean loadFromFile = false;
    private boolean loadFromProperties = false;
    private boolean loadFromInputStream = false;
    private InputStream in = null;
    private String propertyFileName = null;
    private boolean throwIOExceptions = true;
    private Properties properties = null;
    private boolean loaded = false;

    public PropertyDefaultSource(String propertyFileName, boolean throwIOExceptions) {
        this.loadFromFile = true;
        this.propertyFileName = propertyFileName;
        this.throwIOExceptions = throwIOExceptions;
    }

    public PropertyDefaultSource(Properties properties) {
        this.loadFromProperties = true;
        this.properties = properties;
        this.loaded = true;
    }

    public PropertyDefaultSource(InputStream in, boolean throwIOExceptions) {
        this.loadFromInputStream = true;
        this.in = in;
        this.throwIOExceptions = throwIOExceptions;
    }

    private Properties getProperties() throws IOException {
        Properties result;
        block5: {
            if (!this.loaded) {
                try {
                    if (this.loadFromFile) {
                        this.in = new BufferedInputStream(new FileInputStream(this.propertyFileName));
                    }
                    Properties properties = new Properties();
                    properties.load(this.in);
                    this.in.close();
                    this.in = null;
                    this.properties = properties;
                    this.loaded = true;
                }
                catch (IOException e) {
                    if (!this.throwIOExceptions) break block5;
                    throw e;
                }
            }
        }
        if ((result = this.properties) == null) {
            result = this.properties = new Properties();
            this.loaded = true;
        }
        return result;
    }

    @Override
    public Defaults getDefaults(IDMap idMap, ExceptionMap exceptionMap) {
        Defaults defaults = new Defaults();
        try {
            Properties properties = this.getProperties();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String thisName = (String)enumeration.nextElement();
                if (idMap.idExists(thisName)) {
                    defaults.addDefault(thisName, properties.getProperty(thisName));
                    continue;
                }
                String paramID = idMap.getIDByLongFlag(thisName);
                if (paramID != null) {
                    defaults.addDefault(paramID, properties.getProperty(thisName));
                    continue;
                }
                if (thisName.length() == 1) {
                    paramID = idMap.getIDByShortFlag(thisName.charAt(0));
                    if (paramID != null) {
                        defaults.addDefault(paramID, properties.getProperty(thisName));
                        continue;
                    }
                    exceptionMap.addException(null, new JSAPException("Unknown parameter: " + thisName));
                    continue;
                }
                exceptionMap.addException(null, new JSAPException("Unknown parameter: " + thisName));
            }
        }
        catch (IOException ioe) {
            exceptionMap.addException(null, new JSAPException("Unable to load properties.", ioe));
        }
        return defaults;
    }
}

