/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.awt.Color;
import org.broad.igv.ui.WaitCursorManager;

public class RegionOfInterest {
    private String chr;
    private String description;
    private int start;
    private int end;
    private static Color backgroundColor = Color.RED;
    private static Color foregroundColor = Color.BLACK;
    boolean selected = false;
    private WaitCursorManager.CursorToken token;

    public RegionOfInterest(String chromosomeName, int start, int end, String description) {
        this.chr = chromosomeName;
        this.description = description;
        this.start = start;
        this.end = end;
    }

    public String getTooltip() {
        return this.description == null ? this.chr + ":" + this.getDisplayStart() + "-" + this.getDisplayEnd() : this.description;
    }

    public String getChr() {
        return this.chr;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getDisplayEnd() {
        return this.getEnd();
    }

    public int getStart() {
        return this.start;
    }

    public int getCenter() {
        return (this.start + this.end) / 2;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public int getDisplayStart() {
        return this.getStart() + 1;
    }

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    public String getLocusString() {
        return this.getChr() + ":" + this.getDisplayStart() + "-" + this.getDisplayEnd();
    }
}

