/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class ByteBufferHelper {
    public static final char getChar(ByteBuffer buffer, ByteOrder order) {
        return (char)ByteBufferHelper.getShort(buffer, order);
    }

    public static final void putChar(ByteBuffer buffer, char value, ByteOrder order) {
        ByteBufferHelper.putShort(buffer, (short)value, order);
    }

    public static final char getChar(ByteBuffer buffer, int index, ByteOrder order) {
        return (char)ByteBufferHelper.getShort(buffer, index, order);
    }

    public static final void putChar(ByteBuffer buffer, int index, char value, ByteOrder order) {
        ByteBufferHelper.putShort(buffer, index, (short)value, order);
    }

    public static final short getShort(ByteBuffer buffer, ByteOrder order) {
        buffer.checkForUnderflow(2);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return (short)((buffer.get() & 0xFF) + (buffer.get() << 8));
        }
        return (short)((buffer.get() << 8) + (buffer.get() & 0xFF));
    }

    public static final void putShort(ByteBuffer buffer, short value, ByteOrder order) {
        buffer.checkForOverflow(2);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            buffer.put((byte)value);
            buffer.put((byte)(value >> 8));
        } else {
            buffer.put((byte)(value >> 8));
            buffer.put((byte)value);
        }
    }

    public static final short getShort(ByteBuffer buffer, int index, ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return (short)((buffer.get(index) & 0xFF) + (buffer.get(++index) << 8));
        }
        return (short)((buffer.get(index) << 8) + (buffer.get(++index) & 0xFF));
    }

    public static final void putShort(ByteBuffer buffer, int index, short value, ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            buffer.put(index, (byte)value);
            buffer.put(++index, (byte)(value >> 8));
        } else {
            buffer.put(index, (byte)(value >> 8));
            buffer.put(++index, (byte)value);
        }
    }

    public static final int getInt(ByteBuffer buffer, ByteOrder order) {
        buffer.checkForUnderflow(4);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return (buffer.get() & 0xFF) + ((buffer.get() & 0xFF) << 8) + ((buffer.get() & 0xFF) << 16) + (buffer.get() << 24);
        }
        return (buffer.get() << 24) + ((buffer.get() & 0xFF) << 16) + ((buffer.get() & 0xFF) << 8) + (buffer.get() & 0xFF);
    }

    public static final void putInt(ByteBuffer buffer, int value, ByteOrder order) {
        buffer.checkForOverflow(4);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            buffer.put((byte)value);
            buffer.put((byte)(value >> 8));
            buffer.put((byte)(value >> 16));
            buffer.put((byte)(value >> 24));
        } else {
            buffer.put((byte)(value >> 24));
            buffer.put((byte)(value >> 16));
            buffer.put((byte)(value >> 8));
            buffer.put((byte)value);
        }
    }

    public static final int getInt(ByteBuffer buffer, int index, ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return (buffer.get(index) & 0xFF) + ((buffer.get(++index) & 0xFF) << 8) + ((buffer.get(++index) & 0xFF) << 16) + (buffer.get(++index) << 24);
        }
        return (buffer.get(index) << 24) + ((buffer.get(++index) & 0xFF) << 16) + ((buffer.get(++index) & 0xFF) << 8) + (buffer.get(++index) & 0xFF);
    }

    public static final void putInt(ByteBuffer buffer, int index, int value, ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            buffer.put(index, (byte)value);
            buffer.put(++index, (byte)(value >> 8));
            buffer.put(++index, (byte)(value >> 16));
            buffer.put(++index, (byte)(value >> 24));
        } else {
            buffer.put(index, (byte)(value >> 24));
            buffer.put(++index, (byte)(value >> 16));
            buffer.put(++index, (byte)(value >> 8));
            buffer.put(++index, (byte)value);
        }
    }

    public static final long getLong(ByteBuffer buffer, ByteOrder order) {
        buffer.checkForUnderflow(8);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return (long)((buffer.get() & 0xFF) + ((buffer.get() & 0xFF) << 8) + ((buffer.get() & 0xFF) << 16)) + (((long)buffer.get() & 0xFFL) << 24) + (((long)buffer.get() & 0xFFL) << 32) + (((long)buffer.get() & 0xFFL) << 40) + (((long)buffer.get() & 0xFFL) << 48) + ((long)buffer.get() << 56);
        }
        return ((long)buffer.get() << 56) + (((long)buffer.get() & 0xFFL) << 48) + (((long)buffer.get() & 0xFFL) << 40) + (((long)buffer.get() & 0xFFL) << 32) + (((long)buffer.get() & 0xFFL) << 24) + (long)((buffer.get() & 0xFF) << 16) + (long)((buffer.get() & 0xFF) << 8) + (long)(buffer.get() & 0xFF);
    }

    public static final void putLong(ByteBuffer buffer, long value, ByteOrder order) {
        buffer.checkForOverflow(8);
        if (order == ByteOrder.LITTLE_ENDIAN) {
            buffer.put((byte)value);
            buffer.put((byte)(value >> 8));
            buffer.put((byte)(value >> 16));
            buffer.put((byte)(value >> 24));
            buffer.put((byte)(value >> 32));
            buffer.put((byte)(value >> 40));
            buffer.put((byte)(value >> 48));
            buffer.put((byte)(value >> 56));
        } else {
            buffer.put((byte)(value >> 56));
            buffer.put((byte)(value >> 48));
            buffer.put((byte)(value >> 40));
            buffer.put((byte)(value >> 32));
            buffer.put((byte)(value >> 24));
            buffer.put((byte)(value >> 16));
            buffer.put((byte)(value >> 8));
            buffer.put((byte)value);
        }
    }

    public static final long getLong(ByteBuffer buffer, int index, ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return (long)((buffer.get(index) & 0xFF) + ((buffer.get(++index) & 0xFF) << 8) + ((buffer.get(++index) & 0xFF) << 16)) + (((long)buffer.get(++index) & 0xFFL) << 24) + (((long)buffer.get(++index) & 0xFFL) << 32) + (((long)buffer.get(++index) & 0xFFL) << 40) + (((long)buffer.get(++index) & 0xFFL) << 48) + ((long)buffer.get(++index) << 56);
        }
        return ((long)buffer.get(index) << 56) + (((long)buffer.get(++index) & 0xFFL) << 48) + (((long)buffer.get(++index) & 0xFFL) << 40) + (((long)buffer.get(++index) & 0xFFL) << 32) + (((long)buffer.get(++index) & 0xFFL) << 24) + (long)((buffer.get(++index) & 0xFF) << 16) + (long)((buffer.get(++index) & 0xFF) << 8) + (long)(buffer.get(++index) & 0xFF);
    }

    public static final void putLong(ByteBuffer buffer, int index, long value, ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            buffer.put(index, (byte)value);
            buffer.put(++index, (byte)(value >> 8));
            buffer.put(++index, (byte)(value >> 16));
            buffer.put(++index, (byte)(value >> 24));
            buffer.put(++index, (byte)(value >> 32));
            buffer.put(++index, (byte)(value >> 40));
            buffer.put(++index, (byte)(value >> 48));
            buffer.put(++index, (byte)(value >> 56));
        } else {
            buffer.put(index, (byte)(value >> 56));
            buffer.put(++index, (byte)(value >> 48));
            buffer.put(++index, (byte)(value >> 40));
            buffer.put(++index, (byte)(value >> 32));
            buffer.put(++index, (byte)(value >> 24));
            buffer.put(++index, (byte)(value >> 16));
            buffer.put(++index, (byte)(value >> 8));
            buffer.put(++index, (byte)value);
        }
    }

    public static final float getFloat(ByteBuffer buffer, ByteOrder order) {
        return Float.intBitsToFloat(ByteBufferHelper.getInt(buffer, order));
    }

    public static final void putFloat(ByteBuffer buffer, float value, ByteOrder order) {
        ByteBufferHelper.putInt(buffer, Float.floatToRawIntBits(value), order);
    }

    public static final float getFloat(ByteBuffer buffer, int index, ByteOrder order) {
        return Float.intBitsToFloat(ByteBufferHelper.getInt(buffer, index, order));
    }

    public static final void putFloat(ByteBuffer buffer, int index, float value, ByteOrder order) {
        ByteBufferHelper.putInt(buffer, index, Float.floatToRawIntBits(value), order);
    }

    public static final double getDouble(ByteBuffer buffer, ByteOrder order) {
        return Double.longBitsToDouble(ByteBufferHelper.getLong(buffer, order));
    }

    public static final void putDouble(ByteBuffer buffer, double value, ByteOrder order) {
        ByteBufferHelper.putLong(buffer, Double.doubleToRawLongBits(value), order);
    }

    public static final double getDouble(ByteBuffer buffer, int index, ByteOrder order) {
        return Double.longBitsToDouble(ByteBufferHelper.getLong(buffer, index, order));
    }

    public static final void putDouble(ByteBuffer buffer, int index, double value, ByteOrder order) {
        ByteBufferHelper.putLong(buffer, index, Double.doubleToRawLongBits(value), order);
    }

    ByteBufferHelper() {
    }
}

