/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;

public class JScrollPane
extends JComponent
implements Accessible,
ScrollPaneConstants {
    private static final long serialVersionUID = 5203525440012340014L;
    protected JViewport columnHeader;
    protected JViewport rowHeader;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected JScrollBar horizontalScrollBar;
    protected int horizontalScrollBarPolicy;
    protected JScrollBar verticalScrollBar;
    protected int verticalScrollBarPolicy;
    protected JViewport viewport;
    Border viewportBorder;
    boolean wheelScrollingEnabled;

    public JViewport getColumnHeader() {
        return this.columnHeader;
    }

    public Component getCorner(String key) {
        if (this.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            if (key == "LOWER_LEADING_CORNER") {
                key = "LOWER_LEFT_CORNER";
            } else if (key == "LOWER_TRAILING_CORNER") {
                key = "LOWER_RIGHT_CORNER";
            } else if (key == "UPPER_LEADING_CORNER") {
                key = "UPPER_LEFT_CORNER";
            } else if (key == "UPPER_TRAILING_CORNER") {
                key = "UPPER_RIGHT_CORNER";
            }
        } else if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            if (key == "LOWER_LEADING_CORNER") {
                key = "LOWER_RIGHT_CORNER";
            } else if (key == "LOWER_TRAILING_CORNER") {
                key = "LOWER_LEFT_CORNER";
            } else if (key == "UPPER_LEADING_CORNER") {
                key = "UPPER_RIGHT_CORNER";
            } else if (key == "UPPER_TRAILING_CORNER") {
                key = "UPPER_LEFT_CORNER";
            }
        }
        if (key == "LOWER_RIGHT_CORNER") {
            return this.lowerRight;
        }
        if (key == "UPPER_RIGHT_CORNER") {
            return this.upperRight;
        }
        if (key == "LOWER_LEFT_CORNER") {
            return this.lowerLeft;
        }
        if (key == "UPPER_LEFT_CORNER") {
            return this.upperLeft;
        }
        return null;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.horizontalScrollBarPolicy;
    }

    public JViewport getRowHeader() {
        return this.rowHeader;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public int getVerticalScrollBarPolicy() {
        return this.verticalScrollBarPolicy;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public Border getViewportBorder() {
        return this.viewportBorder;
    }

    public Rectangle getViewportBorderBounds() {
        if (this.viewportBorder == null) {
            if (this.getViewport() == null) {
                return new Rectangle(0, 0, 0, 0);
            }
            return this.getViewport().getBounds();
        }
        Insets i = this.viewportBorder.getBorderInsets(this.getViewport());
        if (this.getViewport() == null) {
            return new Rectangle(0, 0, i.left + i.right, i.top + i.bottom);
        }
        Rectangle b = this.getViewport().getBounds();
        return new Rectangle(b.x - i.left, b.y - i.top, b.width + i.left + i.right, b.height + i.top + i.bottom);
    }

    public boolean isWheelScrollingEnabled() {
        return this.wheelScrollingEnabled;
    }

    private final void sync() {
        LayoutManager m = super.getLayout();
        if (m != null && m instanceof ScrollPaneLayout) {
            ScrollPaneLayout sl = (ScrollPaneLayout)m;
            sl.syncWithScrollPane(this);
        }
    }

    private final void removeNonNull(Component c) {
        if (c != null) {
            this.remove(c);
        }
    }

    private final void addNonNull(Component c, Object constraints) {
        if (c != null) {
            this.add(c, constraints);
        }
    }

    public void setComponentOrientation(ComponentOrientation co) {
        ComponentOrientation old = super.getComponentOrientation();
        super.setComponentOrientation(co);
        this.firePropertyChange("componentOrientation", old, co);
        this.sync();
    }

    public void setColumnHeader(JViewport h) {
        if (this.columnHeader == h) {
            return;
        }
        JViewport old = this.columnHeader;
        this.removeNonNull(old);
        this.columnHeader = h;
        this.addNonNull(h, "COLUMN_HEADER");
        this.firePropertyChange("columnHeader", old, h);
        this.sync();
    }

    public void setColumnHeaderView(Component c) {
        if (this.columnHeader == null) {
            this.setColumnHeader(this.createViewport());
        }
        this.columnHeader.setView(c);
        this.sync();
    }

    public void setCorner(String key, Component c) {
        if (this.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            if (key == "LOWER_LEADING_CORNER") {
                key = "LOWER_LEFT_CORNER";
            } else if (key == "LOWER_TRAILING_CORNER") {
                key = "LOWER_RIGHT_CORNER";
            } else if (key == "UPPER_LEADING_CORNER") {
                key = "UPPER_LEFT_CORNER";
            } else if (key == "UPPER_TRAILING_CORNER") {
                key = "UPPER_RIGHT_CORNER";
            }
        } else if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            if (key == "LOWER_LEADING_CORNER") {
                key = "LOWER_RIGHT_CORNER";
            } else if (key == "LOWER_TRAILING_CORNER") {
                key = "LOWER_LEFT_CORNER";
            } else if (key == "UPPER_LEADING_CORNER") {
                key = "UPPER_RIGHT_CORNER";
            } else if (key == "UPPER_TRAILING_CORNER") {
                key = "UPPER_LEFT_CORNER";
            }
        }
        if (key == "LOWER_RIGHT_CORNER") {
            this.removeNonNull(this.lowerRight);
            this.lowerRight = c;
            this.addNonNull(c, "LOWER_RIGHT_CORNER");
        } else if (key == "UPPER_RIGHT_CORNER") {
            this.removeNonNull(this.upperRight);
            this.upperRight = c;
            this.addNonNull(c, "UPPER_RIGHT_CORNER");
        } else if (key == "LOWER_LEFT_CORNER") {
            this.removeNonNull(this.lowerLeft);
            this.lowerLeft = c;
            this.addNonNull(c, "LOWER_LEFT_CORNER");
        } else if (key == "UPPER_LEFT_CORNER") {
            this.removeNonNull(this.upperLeft);
            this.upperLeft = c;
            this.addNonNull(c, "UPPER_LEFT_CORNER");
        } else {
            throw new IllegalArgumentException("unknown corner " + key);
        }
        this.sync();
    }

    public void setHorizontalScrollBar(JScrollBar h) {
        if (this.horizontalScrollBar == h) {
            return;
        }
        JScrollBar old = this.horizontalScrollBar;
        this.removeNonNull(old);
        this.horizontalScrollBar = h;
        this.addNonNull(h, "HORIZONTAL_SCROLLBAR");
        this.firePropertyChange("horizontalScrollBar", old, h);
        this.sync();
    }

    public void setHorizontalScrollBarPolicy(int h) {
        if (this.horizontalScrollBarPolicy == h) {
            return;
        }
        if (h != 30 && h != 31 && h != 32) {
            throw new IllegalArgumentException("unknown horizontal scrollbar policy");
        }
        int old = this.horizontalScrollBarPolicy;
        this.horizontalScrollBarPolicy = h;
        this.firePropertyChange("horizontalScrollBarPolicy", old, h);
        this.sync();
        this.revalidate();
    }

    public void setLayout(LayoutManager l) {
        LayoutManager old = super.getLayout();
        ScrollPaneLayout tmp = (ScrollPaneLayout)l;
        super.setLayout(l);
        tmp.syncWithScrollPane(this);
        this.firePropertyChange("layout", old, l);
        this.sync();
    }

    public void setRowHeader(JViewport v) {
        if (this.rowHeader == v) {
            return;
        }
        JViewport old = this.rowHeader;
        this.removeNonNull(old);
        this.rowHeader = v;
        this.addNonNull(v, "ROW_HEADER");
        this.firePropertyChange("rowHeader", old, v);
        this.sync();
    }

    public void setRowHeaderView(Component c) {
        if (this.rowHeader == null) {
            this.setRowHeader(this.createViewport());
        }
        this.rowHeader.setView(c);
        this.sync();
    }

    public void setVerticalScrollBar(JScrollBar v) {
        if (this.verticalScrollBar == v) {
            return;
        }
        JScrollBar old = this.verticalScrollBar;
        this.removeNonNull(old);
        this.verticalScrollBar = v;
        this.addNonNull(v, "VERTICAL_SCROLLBAR");
        this.firePropertyChange("verticalScrollBar", old, v);
        this.sync();
    }

    public void setVerticalScrollBarPolicy(int v) {
        if (this.verticalScrollBarPolicy == v) {
            return;
        }
        if (v != 20 && v != 21 && v != 22) {
            throw new IllegalArgumentException("unknown vertical scrollbar policy");
        }
        int old = this.verticalScrollBarPolicy;
        this.verticalScrollBarPolicy = v;
        this.firePropertyChange("verticalScrollBarPolicy", old, v);
        this.sync();
        this.revalidate();
    }

    public void setWheelScrollingEnabled(boolean b) {
        if (this.wheelScrollingEnabled == b) {
            return;
        }
        boolean old = this.wheelScrollingEnabled;
        this.wheelScrollingEnabled = b;
        this.firePropertyChange("wheelScrollingEnabled", old, b);
        this.sync();
    }

    public void setViewport(JViewport v) {
        if (this.viewport == v) {
            return;
        }
        JViewport old = this.viewport;
        this.removeNonNull(old);
        this.viewport = v;
        this.addNonNull(v, "VIEWPORT");
        this.revalidate();
        this.repaint();
        this.firePropertyChange("viewport", old, v);
        this.sync();
        if (this.accessibleContext != null) {
            AccessibleJScrollPane asp = (AccessibleJScrollPane)this.accessibleContext;
            asp.resetViewPort();
        }
    }

    public void setViewportBorder(Border b) {
        if (this.viewportBorder == b) {
            return;
        }
        Border old = this.viewportBorder;
        this.viewportBorder = b;
        this.firePropertyChange("viewportBorder", old, b);
        this.sync();
    }

    public void setViewportView(Component view) {
        if (this.getViewport() == null) {
            this.setViewport(this.createViewport());
        }
        if (view != null) {
            this.getViewport().setView(view);
        }
        this.sync();
    }

    public boolean isValidateRoot() {
        return true;
    }

    public JScrollBar createHorizontalScrollBar() {
        return new ScrollBar(0);
    }

    public JScrollBar createVerticalScrollBar() {
        return new ScrollBar(1);
    }

    protected JViewport createViewport() {
        return new JViewport();
    }

    public String getUIClassID() {
        return "ScrollPaneUI";
    }

    public void updateUI() {
        ScrollPaneUI b = (ScrollPaneUI)UIManager.getUI(this);
        this.setUI(b);
    }

    public ScrollPaneUI getUI() {
        return (ScrollPaneUI)this.ui;
    }

    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollPane();
        }
        return this.accessibleContext;
    }

    public JScrollPane() {
        this(null);
    }

    public JScrollPane(Component view) {
        this(view, 20, 30);
    }

    public JScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public JScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        this.setVerticalScrollBarPolicy(vsbPolicy);
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBarPolicy(hsbPolicy);
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        this.viewport = this.createViewport();
        if (view != null) {
            this.getViewport().setView(view);
        }
        this.add((Component)this.viewport, 0);
        this.setLayout(new ScrollPaneLayout());
        this.setOpaque(false);
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJScrollPane
    extends JComponent.AccessibleJComponent
    implements ChangeListener,
    PropertyChangeListener {
        protected JViewport viewPort;

        public void stateChanged(ChangeEvent event) {
        }

        public void propertyChange(PropertyChangeEvent e) {
        }

        public void resetViewPort() {
            this.viewPort.removeChangeListener(this);
            this.viewPort.removePropertyChangeListener(this);
            this.viewPort = JScrollPane.this.getViewport();
            this.viewPort.addChangeListener(this);
            this.viewPort.addPropertyChangeListener(this);
        }

        public AccessibleJScrollPane() {
            this.viewPort = JScrollPane.this.getViewport();
            this.viewPort.addChangeListener(this);
            this.viewPort.addPropertyChangeListener(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ScrollBar
    extends JScrollBar
    implements UIResource {
        private static final long serialVersionUID = -42032395320987283L;

        public int getBlockIncrement(int direction) {
            Component view = JScrollPane.this.getViewport().getView();
            if (view == null || !(view instanceof Scrollable)) {
                return super.getBlockIncrement(direction);
            }
            Scrollable s = (Scrollable)((Object)view);
            return s.getScrollableBlockIncrement(JScrollPane.this.getViewport().getViewRect(), this.getOrientation(), direction);
        }

        public int getUnitIncrement(int direction) {
            Component view = JScrollPane.this.getViewport().getView();
            if (view == null || !(view instanceof Scrollable)) {
                return super.getUnitIncrement(direction);
            }
            Scrollable s = (Scrollable)((Object)view);
            return s.getScrollableUnitIncrement(JScrollPane.this.getViewport().getViewRect(), this.getOrientation(), direction);
        }

        public ScrollBar(int orientation) {
            super(orientation);
        }
    }
}

