class SushiNet::StoreItemView < Borges::Component

  attr_accessor :item

  def add_to_cart
    session.add_to_cart @item
  end

  def initialize(item)
    @item = item
  end

  def render_content_on(r)
    r.heading @item.title
    r.heading_level @item.subtitle, 3
    r.paragraph @item.description
    r.div do
      r.italic @item.price.to_cents
      r.space

      r.form do
        r.submit_button 'Add to Cart' do add_to_cart end
        r.space
        r.submit_button 'Done' do answer end
      end
    end
  end

end # class SushiNet::StoreItemView

