require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_AMAP_H_)) {
    eval 'sub _UVM_UVM_AMAP_H_ () {1;}' unless defined(&_UVM_UVM_AMAP_H_);
    if(defined(&_KERNEL)) {
	eval 'sub AMAP_SHARED () {0x1;}' unless defined(&AMAP_SHARED);
	eval 'sub AMAP_REFALL () {0x2;}' unless defined(&AMAP_REFALL);
	eval 'sub AMAP_SWAPOFF () {0x4;}' unless defined(&AMAP_SWAPOFF);
	eval 'sub AMAP_COPY_NOWAIT () {0x2;}' unless defined(&AMAP_COPY_NOWAIT);
	eval 'sub AMAP_COPY_NOCHUNK () {0x4;}' unless defined(&AMAP_COPY_NOCHUNK);
	eval 'sub AMAP_COPY_NOMERGE () {0x8;}' unless defined(&AMAP_COPY_NOMERGE);
	eval 'sub AMAP_EXTEND_BACKWARDS () {0x;}' unless defined(&AMAP_EXTEND_BACKWARDS);
	eval 'sub AMAP_EXTEND_FORWARDS () {0x1;}' unless defined(&AMAP_EXTEND_FORWARDS);
	eval 'sub AMAP_EXTEND_NOWAIT () {0x2;}' unless defined(&AMAP_EXTEND_NOWAIT);
    }
    eval 'sub UVM_AMAP_PPREF () {1;}' unless defined(&UVM_AMAP_PPREF);
    if(defined(&UVM_AMAP_PPREF)) {
    }
    eval 'sub UVM_AMAP_LARGE () {256;}' unless defined(&UVM_AMAP_LARGE);
    eval 'sub UVM_AMAP_CHUNK () {16;}' unless defined(&UVM_AMAP_CHUNK);
    if(defined(&_KERNEL)) {
	eval 'sub AMAP_B2SLOT {
	    my($S,$B) = @_;
    	    eval q({  &KASSERT((($B) & ( &PAGE_SIZE - 1)) == 0); ($S) = ($B) >>  &PAGE_SHIFT; });
	}' unless defined(&AMAP_B2SLOT);
	eval 'sub amap_flags {
	    my($AMAP) = @_;
    	    eval q((($AMAP)-> &am_flags));
	}' unless defined(&amap_flags);
	eval 'sub amap_lock {
	    my($AMAP) = @_;
    	    eval q( &mutex_enter(($AMAP)-> &am_lock));
	}' unless defined(&amap_lock);
	eval 'sub amap_lock_try {
	    my($AMAP) = @_;
    	    eval q( &mutex_tryenter(($AMAP)-> &am_lock));
	}' unless defined(&amap_lock_try);
	eval 'sub amap_refs {
	    my($AMAP) = @_;
    	    eval q((($AMAP)-> &am_ref));
	}' unless defined(&amap_refs);
	eval 'sub amap_unlock {
	    my($AMAP) = @_;
    	    eval q( &mutex_exit(($AMAP)-> &am_lock));
	}' unless defined(&amap_unlock);
	if(defined(&UVM_AMAP_PPREF)) {
	    eval 'sub PPREF_NONE () {( -1);}' unless defined(&PPREF_NONE);
	}
    }
}
1;
