/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.ngs;

import ngs.Package;

class Logger {
    private String version;
    private Level level;
    private static Logger logger = new Logger();

    private Logger() {
        String string = System.getProperty("vdb.log");
        this.level = string == null || string.equals("WARNING") ? Level.WARNING : (string.equals("OFF") ? Level.OFF : (string.equals("INFO") ? Level.INFO : (string.equals("FINE") ? Level.FINE : (string.equals("FINER") ? Level.FINER : (string.equals("FINEST") ? Level.FINEST : Level.FINE)))));
    }

    static void warning(String string) {
        Logger.log(Level.WARNING, string);
    }

    static void info(String string) {
        Logger.log(Level.INFO, string);
    }

    static void fine(String string) {
        Logger.log(Level.FINE, string);
    }

    static void finer(String string) {
        Logger.log(Level.FINER, string);
    }

    static void finest(String string) {
        Logger.log(Level.FINEST, string);
    }

    static void fine(Throwable throwable) {
        Logger.fine(throwable.toString());
    }

    static void finest(Throwable throwable) {
        Logger.finest(throwable.toString());
    }

    static void finest(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        String string = null;
        for (String string2 : stringArray) {
            string = string == null ? "" : string + " ";
            string = string + string2;
        }
        Logger.finest(string);
    }

    static void log(Level level, String string) {
        logger.go(level, string);
    }

    static Level getLevel() {
        return Logger.logger.level;
    }

    static void setLevel(Level level) {
        Logger.logger.level = level;
    }

    private void go(Level level, String string) {
        if (this.level.id() < level.id()) {
            return;
        }
        String string2 = this.getVersion();
        String string3 = "ngs-java" + (string2 != null ? "." + string2 : "") + ": " + string;
        System.err.println(string3);
    }

    private String getVersion() {
        if (this.version == null) {
            try {
                this.version = Package.getPackageVersion();
            }
            catch (Throwable throwable) {
                this.version = null;
            }
        }
        return this.version;
    }

    static enum Level {
        OFF(0),
        WARNING(1),
        INFO(2),
        FINE(3),
        FINER(4),
        FINEST(5);

        private final int id;

        private Level(int n2) {
            this.id = n2;
        }

        private int id() {
            return this.id;
        }
    }
}

