/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.filters;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import java.util.Arrays;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.filters.AbstractAlignmentEntryFilter;

public class BestScoreOnlyAlignmentFilter
extends AbstractAlignmentEntryFilter {
    private final float[] indexToBestScore;
    private final int minQueryIndex;

    public BestScoreOnlyAlignmentFilter(int maxNumberOfReads, int minQueryIndex) {
        this.indexToBestScore = new float[maxNumberOfReads];
        Arrays.fill(this.indexToBestScore, Float.MIN_VALUE);
        this.minQueryIndex = minQueryIndex;
    }

    @Override
    public void setTargetIdentifiers(IndexedIdentifier targets) {
    }

    @Override
    public void inspectEntry(Alignments.AlignmentEntry entry) {
        float score;
        int index = entry.getQueryIndex();
        float previousScore = this.indexToBestScore[index - this.minQueryIndex];
        if (previousScore < (score = entry.getScore())) {
            this.indexToBestScore[index - this.minQueryIndex] = score;
        }
    }

    @Override
    public boolean shouldRetainEntry(Alignments.AlignmentEntry entry) {
        int index = entry.getQueryIndex();
        float score = entry.getScore();
        float keepHighestScore = this.indexToBestScore[index - this.minQueryIndex];
        if (keepHighestScore == Float.MIN_VALUE) {
            return false;
        }
        return keepHighestScore == score;
    }

    @Override
    public synchronized void postProcessing() {
    }
}

