/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import org.postgresql.core.ObjectPool;

public class SimpleObjectPool
implements ObjectPool {
    int cursize = 0;
    int maxsize = 16;
    Object[] arr = new Object[this.maxsize];

    public void add(Object object) {
        if (this.cursize >= this.maxsize) {
            Object[] objectArray = new Object[this.maxsize * 2];
            System.arraycopy(this.arr, 0, objectArray, 0, this.maxsize);
            this.maxsize *= 2;
            this.arr = objectArray;
        }
        this.arr[this.cursize++] = object;
    }

    public void addAll(ObjectPool objectPool) {
        SimpleObjectPool simpleObjectPool = (SimpleObjectPool)objectPool;
        int n = simpleObjectPool.size();
        if (n == 0) {
            return;
        }
        int n2 = n + this.cursize;
        if (n2 > this.maxsize) {
            Object[] objectArray = new Object[n2 * 2];
            System.arraycopy(this.arr, 0, objectArray, 0, this.cursize);
            this.maxsize = this.maxsize = n2 * 2;
            this.arr = objectArray;
        }
        System.arraycopy(simpleObjectPool.arr, 0, this.arr, this.cursize, n);
        this.cursize = n2;
    }

    public void clear() {
        this.cursize = 0;
    }

    public boolean isEmpty() {
        return this.cursize == 0;
    }

    public Object remove() {
        return this.arr[--this.cursize];
    }

    public void remove(Object object) {
        int n = 0;
        while (n < this.cursize && !this.arr[n].equals(object)) {
            ++n;
        }
        if (this.arr[n].equals(object)) {
            System.arraycopy(this.arr, n + 1, this.arr, n, this.cursize - n);
            --this.cursize;
        }
    }

    public int size() {
        return this.cursize;
    }
}

