/*
 * SQLExecutionComponent.java
 *
 * Created on 19 de julio de 2002, 10:29
 */

package frames;
import components.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.undo.*;

/**
 *
 * @author  nestor
 */
public class SQLExecutionComponent extends JSplitPane{
    private SQLExecutionFrame frame = null;
    private JTextPane sql_text = null;
    private SQLTable sql_result = null;
    
    private UndoManager undo = new UndoManager();
    
    public SQLExecutionComponent(SQLExecutionFrame _frame) {
        super(JSplitPane.VERTICAL_SPLIT);
        frame = _frame;
        
        sql_text = new JTextPane();
        Font tmp = new Font(sql_text.getFont().getFontName(), sql_text.getFont().getStyle(), 14);
        sql_text.setFont(tmp);
        this.add(new JScrollPane(sql_text));
        sql_text.getDocument().addUndoableEditListener(new MyUndoableEditListener());
        
        
        sql_result = new SQLTable();
        JScrollPane panel = new JScrollPane(sql_result);
        panel.setForeground(Color.white);
        this.add(panel);
        
        setPreferredSize(new Dimension(600, 350));
        setOneTouchExpandable(true);
        setDividerLocation(250);
    }
    
    public void  refreshValidation(){
        if(frame != null){
            boolean valid = frame.getPrincipalFrame().getDatabase().validate();
            sql_text.setEnabled(valid);
            sql_result.setEnabled(valid);
        }
    }
    
    public SQLTable getTable(){
        return sql_result;
    }
    public JTextPane getText(){
        return sql_text;
    }
    
    public void appendText(String _text){
        try{
            sql_text.getDocument().insertString(sql_text.getDocument().getEndPosition().getOffset() -1, _text, null);
        } catch (Exception e){
            e.printStackTrace();
        }
    }
    
    public void undo(){
        try{
            undo.undo();
        } catch (Exception e){}
    }
    public void redo(){
        try{
            undo.redo();
        } catch (Exception e){}
    }
    
    protected class MyUndoableEditListener  implements UndoableEditListener {
        public void undoableEditHappened(UndoableEditEvent e) {
            undo.addEdit(e.getEdit());
/*            undoAction.updateUndoState();
            redoAction.updateRedoState();*/
        }
    }
}
