/*
 * Utilities.java
 *
 * Created on 18 de julio de 2002, 11:56
 */

package pgclibrary.utilities;

import java.text.*;
import java.util.*;

/** Es una libreria de de funciones generales.
 *
 * @author Nestor Marsollier
 * @version 1.0
 */
public class Utilities extends Object {
    public static final String FORMAT_DATE = "dd/MM/yyyy";
    public static final String FORMAT_DATETIME = "dd/MM/yyyy HH:mm:ss";
    
    private Utilities(){
    }
    
    /** Transforma Pulgadas a Milimetros
     * @param nro Numero en pulgadas.
     * @return Milimetros
     */
    public float PM(double nro){
        return (float) (nro * 0.35 );
    }
    
    
    /** Redondea el numero a la cantidad de decimales indicados
     * @param _number Numero a redondear
     * @param _num_decimals cantidad de decimales
     * @return numero redondeado
     */
    public static double round(double _number, int _num_decimals){
        int __decimals = 1;
        for(int i=0; i<_num_decimals; i++){
            __decimals = 10;
        }
        
        return ((double) (((long) (_number * __decimals)) / __decimals));
    }
    
    /** Parsea un String recuperado desde una entrada HTML.
     * Verfiica que los datos sea corresctos y adem\u00e1s verifica el tama\u00f1o del
     * string resultante, lo trunca en caso que sea mayor.
     * @param _source Candea a verificar
     * @param _maxLength tama\u00f1o m\u00e1ximo a controlar
     * @param _upperCase determina si el resultado debe ser pasado a mayousculas
     * @return Cadena parseada correctamente para ser almacenada.
     */
    public static String parseHTMLString(String _source, int _maxLength, boolean _upperCase){
        String retorno = parseHTMLString(_source, _maxLength);
        if(_upperCase){
            retorno = retorno.toUpperCase();
        }
        return retorno;
    }
    
    /** Parsea un String recuperado desde una entrada HTML.
     * Verfiica que los datos sea corresctos y adem\u00e1s verifica el tama\u00f1o del
     * string resultante, lo trunca en caso que sea mayor.
     * @param _source Candea a verificar
     * @param _maxLength tama\u00f1o m\u00e1ximo a controlar
     * @return Cadena parseada correctamente para ser almacenada.
     */
    public static String parseHTMLString(String _source, int _maxLength){
        String retorno = parseHTMLString(_source);
        if(retorno.length() > _maxLength){
            retorno = retorno.substring(0, _maxLength);
        }
        return retorno;
    }
    

    public static String replaceAll(String _cadena, String _caracterBuscado, String _cadenaReemplazo){
        int pos = _cadena.indexOf(_caracterBuscado);
        while(pos >=0){
            _cadena = _cadena.substring(0, pos) + _cadenaReemplazo + _cadena.substring(pos+ _caracterBuscado.length(), _cadena.length());
            pos = _cadena.indexOf(_caracterBuscado);
        }
        return _cadena;
    }
    
    private static StringBuffer replaceAll(StringBuffer _cadena, char _caracterBuscado, String _cadenaReemplazo){
        int pos = _cadena.toString().indexOf(_caracterBuscado);
        while(pos >=0){
            _cadena = _cadena.replace(pos, pos+1, _cadenaReemplazo);
            pos = _cadena.toString().indexOf(_caracterBuscado);
        }
        return _cadena;
    }
    
    /** Parsea una cadena HTML en una cadena correcta para ser almacenada en
     * la base de datos.
     * @param _source Cadena a parsear
     * @return String correcto.
     */
    public static String parseHTMLString(String _source){
        StringBuffer retorno = new StringBuffer(_source);
        retorno = replaceAll(retorno, '"', "&quot;");
        retorno = replaceAll(retorno, '\'', "&#39;");
        retorno = replaceAll(retorno, '<', "&#60;");
        retorno = replaceAll(retorno, '>', "&#62;");
        return retorno.toString();
    }
    
    
    /** Formatea un numero en una cadena. Esto es \u00fatil para la presentaci\u00f3n de numeros.
     * @param numero numero a formatear.
     *
     * @param _pattern formato que se utiliza
     * @return cadena formateada.
     */
    public static String formatBoolean(boolean _value){
        if(_value){
            return "YES";
        } else {
            return "NO";
        }
    }
    
    /** Formatea un numero en una cadena. Esto es \u00fatil para la presentaci\u00f3n de numeros.
     * @param numero numero a formatear.
     *
     * @param _pattern formato que se utiliza
     * @return cadena formateada.
     */
    public static String formatDecimal(double numero, String _pattern){
        DecimalFormat pesosFormat = new DecimalFormat("#######0.00");
        return pesosFormat.format(numero);
    }
    /** Formatea un numero en una cadea con un formato est\u00e1ndar de dos decimales.
     * @param numero numero a formatear.
     * @return Numero formateado.
     */
    public static String formatDecimal(double numero){
        return formatDecimal(numero, "#######0.00");
    }
    
    /** Formatea una fecha en una cadena con el formato est\u00e1ndar de fecha europeo.
     * @param fecha fecha a formatear.
     * @return Fecha formateada.
     */
    public static String formatDate(java.util.Date fecha){
        return formatDate(fecha, "dd/MM/yyyy");
    }
    /** Formatea una fecha con otro formato distinto al europeo.
     * @param fecha fecha a formatear.
     * @param pattern patr\u00f3n de formato.
     * @return Fecah formateada.
     */
    public static String formatDate(java.util.Date fecha, String pattern){
        String retorno = new String();
        try{
            if ((fecha != null) && (pattern != null)){
                SimpleDateFormat template = new SimpleDateFormat(pattern);
                retorno = template.format(fecha);
            }
        } catch (Exception e){}
        return retorno;
    }
    /** Funci\u00f3n invera a formatDate.  A partir de la cadena se obtiene la fecha
     * que representa  en formato europeo.
     * @param fecha fecha a formatear.
     * @return Date
     */
    public static java.util.Date parseDate(String fecha){
        return parseDate(fecha, "dd/MM/yyyy");
    }
    
    /** Formatea una fecha y obtiene el objeto que la representa.
     * EL formato es personalizado.
     * @param fecha fecha a formatear.
     * @param pattern patron a utilizar en el formato.
     * @return Date
     */
    public static java.util.Date parseDate(String fecha, String pattern){
        java.util.Date retorno = new java.util.Date();
        try{
            if ((fecha != null) && (pattern != null)){
                SimpleDateFormat template = new SimpleDateFormat(pattern);
                retorno = template.parse(fecha);
            }
        } catch (Exception e){}
        return retorno;
    }
    
    public static java.util.Date roundDate(java.util.Date _fecha){
        GregorianCalendar tmp = new GregorianCalendar();
        tmp.setTime(_fecha);
        tmp.set(tmp.MILLISECOND, 0);
        return tmp.getTime();
    }
    
    public static String parseError(Vector _errors){
        StringBuffer retorno = new StringBuffer();
        if(_errors != null){
            for(int i=0; i<_errors.size(); i++){
                retorno.append(_errors.get(i).toString());
                retorno.append("\n");
            }
        }
        return retorno.toString();
    }
}
