/*
 * Decompiled with CFR 0.152.
 */
package components.view;

import components.SQLTable;
import components.SQLTableModel;
import components.view.DataPanelListener;
import components.view.DataPanelOrderDialog;
import components.view.DataPanelToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pgclibrary.dataaccess.dataSourceResultSet;
import pgclibrary.objects.View;

public class DataPanel
extends JPanel {
    private View view = null;
    private SQLTable data_view = new SQLTable();
    private Hashtable tales_order = new Hashtable(100);
    private DataPanelListener listener = null;

    public DataPanel() {
        this.data_view = new SQLTable();
        this.listener = new DataPanelListener(this);
        this.initPanel();
    }

    private void initPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        SQLTableModel sql_tm = new SQLTableModel(this.data_view);
        this.data_view.setModel(sql_tm);
        this.add((Component)new DataPanelToolbar(this), "North");
        this.add((Component)new JScrollPane(this.data_view), "Center");
    }

    public void refresh() {
        dataSourceResultSet dsrs = new dataSourceResultSet(this.view.getConnection(), this.generateSQL());
        ((SQLTableModel)this.data_view.getModel()).setDataSource(dsrs);
        this.repaint();
    }

    public void refresh(View view_object) {
        this.view = view_object;
        this.refresh();
    }

    private String generateSQL() {
        StringBuffer retorno = new StringBuffer();
        if (this.view != null) {
            retorno.append("SELECT * FROM ").append(this.view.getName());
            Vector order = this.getOrder();
            if (order.size() > 0) {
                retorno.append(" ORDER BY ");
                int i = 0;
                while (i < order.size()) {
                    retorno.append(order.get(i));
                    if (i < order.size() - 1) {
                        retorno.append(", ");
                    } else {
                        retorno.append(" ");
                    }
                    ++i;
                }
            }
        }
        return retorno.toString();
    }

    public void addOrder(String _column) {
        Vector order = this.getOrder();
        if (_column != null && this.getOrderPos(_column) < 0) {
            order.add(_column);
        }
    }

    public void clearOrder() {
        this.getOrder().removeAllElements();
    }

    public int getOrderPos(String _column) {
        int retorno = -1;
        Vector order = this.getOrder();
        int i = 0;
        while (i < order.size() && retorno < 0) {
            if (((String)order.get(i)).equals(_column)) {
                retorno = i;
            }
            ++i;
        }
        return retorno;
    }

    public Vector getOrder() {
        Vector retorno = (Vector)this.tales_order.get(this.view.getName());
        if (retorno == null) {
            retorno = new Vector();
            this.tales_order.put(this.view.getName(), retorno);
        }
        return retorno;
    }

    public View getView() {
        return this.view;
    }

    public DataPanelListener getListener() {
        return this.listener;
    }

    public void showOrderDialog() {
        new DataPanelOrderDialog(this).show();
    }

    public void newRecord() {
    }

    public void editRecord() {
    }

    public void deleteRecord() {
    }
}

