#include <uuid.h>

#include <time.h>
#include <sys/time.h>
#include <sys/types.h>

time_t uuid_time(const uuid_p uuid, struct timeval *ret_tv)
{
	uuid_u32_t high;
	struct timeval		tv;

	uuid_u64_t clock_reg;
	
	high = uuid->time_mid | ((uuid->time_hi_and_version & 0xFFF) << 16);
	clock_reg = uuid->time_low | ((uuid_u64_t) high << 32);

	clock_reg -= (((uuid_u64_t) 0x01B21DD2) << 32) + 0x13814000;
	tv.tv_sec = clock_reg / 10000000;
	tv.tv_usec = (clock_reg % 10000000) / 10;

	if (ret_tv)
		*ret_tv = tv;

	return tv.tv_sec;
}
