/*
 * uuid operator routines
 * $Header: /usr/local/cvsroot/pguuid/pguuid/src/opts.c,v 1.4 2003/06/11 02:33:52 xylophone Exp $
 */
#include "util.h"

#include <uuid.h>

#include <postgres.h>
#include <fmgr.h>

/* operator > */
PG_FUNCTION_INFO_V1(uuid_gt);
Datum uuid_gt(PG_FUNCTION_ARGS)
{
	const uuid_p p1 = (uuid_p) GET_ARG_POINTER(0);
	const uuid_p p2 = (uuid_p) GET_ARG_POINTER(1);

	PG_RETURN_BOOL(uuid_compare(p1, p2) > 0);
}

/* operator < */
PG_FUNCTION_INFO_V1(uuid_lt);
Datum uuid_lt(PG_FUNCTION_ARGS)
{
	const uuid_p p1 = (uuid_p) GET_ARG_POINTER(0);
	const uuid_p p2 = (uuid_p) GET_ARG_POINTER(1);

	PG_RETURN_BOOL(uuid_compare(p1, p2) < 0);
}

/* operator == */
PG_FUNCTION_INFO_V1(uuid_eq);
Datum uuid_eq(PG_FUNCTION_ARGS)
{
	const uuid_p p1 = (uuid_p) GET_ARG_POINTER(0);
	const uuid_p p2 = (uuid_p) GET_ARG_POINTER(1);

	PG_RETURN_BOOL(uuid_compare(p1, p2) == 0);
}

/* operator <= */
PG_FUNCTION_INFO_V1(uuid_le);
Datum uuid_le(PG_FUNCTION_ARGS)
{
	const uuid_p p1 = (uuid_p) GET_ARG_POINTER(0);
	const uuid_p p2 = (uuid_p) GET_ARG_POINTER(1);

	PG_RETURN_BOOL(uuid_compare(p1, p2) <= 0);
}

/* operator >= */
PG_FUNCTION_INFO_V1(uuid_ge);
Datum uuid_ge(PG_FUNCTION_ARGS)
{
	const uuid_p p1 = (uuid_p) GET_ARG_POINTER(0);
	const uuid_p p2 = (uuid_p) GET_ARG_POINTER(1);

	PG_RETURN_BOOL(uuid_compare(p1, p2) >= 0);
}

/* operator != */
PG_FUNCTION_INFO_V1(uuid_ne);
Datum uuid_ne(PG_FUNCTION_ARGS)
{
	uuid_p p1 = (uuid_p) GET_ARG_POINTER(0);
	uuid_p p2 = (uuid_p) GET_ARG_POINTER(1);

	PG_RETURN_BOOL(uuid_compare(p1, p2) != 0);
}
