/*-------------------------------------------------------------------------
 *
 * FILE
 *    uuid_generate_name.c
 *
 * DESCRIPTION
 *    generate a name-base UUID
 *
 * Copyright (c) 2002-2003, Mike Wang <xylophone2001@hotmail.com>
 *
 *-------------------------------------------------------------------------
 */
#include "util.h"
#include "md5.h"

#include <uuid.h>

#include <string.h>
#include <netinet/in.h>

int uuid_generate_name(const uuid_p nsid, const char name[], uuid_p out)
{
	md5_state_t state;
/*	md5_byte_t digest[16]; */

	uuid_t net_nsid;

	memcpy(&net_nsid, nsid, sizeof(uuid_t));
	
	htonl (net_nsid.time_low);
	htons (net_nsid.time_mid);
	htons (net_nsid.time_hi_and_version);

	md5_init(&state);
	md5_append(&state, (const md5_byte_t *) &net_nsid, sizeof(uuid_t));
	md5_append(&state, (const md5_byte_t *) name, strlen(name));
	md5_finish(&state, (md5_byte_t *) out);

	/* convert UUID to local byte order */
	ntohl (out->time_low);
	ntohs (out->time_mid);
	ntohs (out->time_hi_and_version);

	/* put in the variant and version bits */
	out->time_hi_and_version &= 0x0FFF;
	out->time_hi_and_version |= (3 << 12);
	out->clock_seq = (out->clock_seq & 0x3FFF) | 0x8000;

	return (0);
}

int uuid_generate_name2(const char namespace[], const char name[], uuid_p out)
{
	md5_state_t state;
	uuid_t nsid;

	md5_init(&state);
	md5_append(&state, (const md5_byte_t *) namespace, strlen(namespace));
	md5_finish(&state, (md5_byte_t *) &nsid);

	return uuid_generate_name(&nsid, name, out);
}
