/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalTargetException;
import org.jdom.Verifier;
import org.jdom.output.XMLOutputter;

public class ProcessingInstruction
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: ProcessingInstruction.java,v $ $Revision: 1.27 $ $Date: 2002/03/20 15:16:32 $ $Name: jdom_1_0_b8 $";
    protected String target;
    protected String rawData;
    protected Map mapData;
    protected Object parent;

    protected ProcessingInstruction() {
    }

    public ProcessingInstruction(String target, String data) {
        String reason = Verifier.checkProcessingInstructionTarget(target);
        if (reason != null) {
            throw new IllegalTargetException(target, reason);
        }
        this.target = target;
        this.setData(data);
    }

    public ProcessingInstruction(String target, Map data) {
        String reason = Verifier.checkProcessingInstructionTarget(target);
        if (reason != null) {
            throw new IllegalTargetException(target, reason);
        }
        this.target = target;
        this.setData(data);
    }

    public Object clone() {
        ProcessingInstruction pi = null;
        try {
            pi = (ProcessingInstruction)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        pi.parent = null;
        if (this.mapData != null) {
            pi.mapData = this.parseData(this.rawData);
        }
        return pi;
    }

    public ProcessingInstruction detach() {
        if (this.parent instanceof Element) {
            ((Element)this.parent).removeContent(this);
        } else if (this.parent instanceof Document) {
            ((Document)this.parent).removeContent(this);
        }
        return this;
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    private String extractQuotedString(String rawData) {
        boolean inQuotes = false;
        char quoteChar = '\"';
        int start = 0;
        int pos = 0;
        while (pos < rawData.length()) {
            char currentChar = rawData.charAt(pos);
            if (currentChar == '\"' || currentChar == '\'') {
                if (!inQuotes) {
                    quoteChar = currentChar;
                    inQuotes = true;
                    start = pos + 1;
                } else if (quoteChar == currentChar) {
                    inQuotes = false;
                    return rawData.substring(start, pos);
                }
            }
            ++pos;
        }
        return null;
    }

    public String getData() {
        return this.rawData;
    }

    public Document getDocument() {
        if (this.parent instanceof Document) {
            return (Document)this.parent;
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    public List getNames() {
        Set mapDataSet = this.mapData.entrySet();
        ArrayList<String> nameList = new ArrayList<String>();
        Iterator i = mapDataSet.iterator();
        while (i.hasNext()) {
            String wholeSet = i.next().toString();
            String attrName = wholeSet.substring(0, wholeSet.indexOf("="));
            nameList.add(attrName);
        }
        return nameList;
    }

    public Element getParent() {
        if (this.parent instanceof Element) {
            return (Element)this.parent;
        }
        return null;
    }

    public String getTarget() {
        return this.target;
    }

    public String getValue(String name) {
        return (String)this.mapData.get(name);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private Map parseData(String rawData) {
        HashMap<String, String> data = new HashMap<String, String>();
        String inputData = rawData.trim();
        while (!inputData.trim().equals("")) {
            String name = "";
            String value = "";
            int startName = 0;
            char previousChar = inputData.charAt(startName);
            int pos = 1;
            while (pos < inputData.length()) {
                char currentChar = inputData.charAt(pos);
                if (currentChar == '=') {
                    name = inputData.substring(startName, pos).trim();
                    value = this.extractQuotedString(inputData.substring(pos + 1).trim());
                    if (value == null) {
                        return new HashMap();
                    }
                    pos += value.length() + 1;
                    break;
                }
                if (Character.isWhitespace(previousChar) && !Character.isWhitespace(currentChar)) {
                    startName = pos;
                }
                previousChar = currentChar;
                ++pos;
            }
            inputData = inputData.substring(pos);
            if (name.length() <= 0 || value == null) continue;
            data.put(name, value);
        }
        return data;
    }

    public boolean removeValue(String name) {
        if (this.mapData.remove(name) != null) {
            this.rawData = this.toString(this.mapData);
            return true;
        }
        return false;
    }

    public ProcessingInstruction setData(String data) {
        this.rawData = data;
        this.mapData = this.parseData(data);
        return this;
    }

    public ProcessingInstruction setData(Map data) {
        this.rawData = this.toString(data);
        this.mapData = data;
        return this;
    }

    protected ProcessingInstruction setDocument(Document document) {
        this.parent = document;
        return this;
    }

    protected ProcessingInstruction setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public ProcessingInstruction setValue(String name, String value) {
        this.mapData.put(name, value);
        this.rawData = this.toString(this.mapData);
        return this;
    }

    public String toString() {
        return "[ProcessingInstruction: " + new XMLOutputter().outputString(this) + "]";
    }

    private String toString(Map mapData) {
        StringBuffer rawData = new StringBuffer();
        Iterator i = mapData.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = (String)mapData.get(name);
            rawData.append(name).append("=\"").append(value).append("\" ");
        }
        rawData.setLength(rawData.length() - 1);
        return rawData.toString();
    }
}

