
#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# General ledger backend code
#
# CHANGE LOG:
#   DS. 2000-07-04  Created
#   DS. 2001-06-12  Changed relations from accno to chart_id
#
#======================================================================

package report;

sub all_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
 ($customerno, $form->{customer1}) = split(/--/, $form->{customerno});
  if ($form->{customer1}) {
    my $source = $form->like(lc $form->{customer1});
    $glwhere .= " AND lower(invoice_listing.customer_id) LIKE '$source'";
  }

  if ($form->{parts_id}) {
 
	  $glwhere .= " AND invoice_listing.parts_id=$form->{parts_id}";
  }
  
  if ($form->{transtypeno}) {
    my $source = $form->like(lc $form->{transtypeno});
    $glwhere .= " AND lower(invoice_listing.transtype) LIKE '$source'";
  }  if ($form->{batchno}) {
    my $source = $form->like(lc $form->{batchno});
    $glwhere .= " AND lower(invoice_listing.batch) LIKE '$source'";
  }  if ($form->{transnono}) {
    my $source = $form->like(lc $form->{transnono});
    $glwhere .= " AND lower(invoice_listing.transno) LIKE '$source'";
  }  if ($form->{subtransnono}) {
    my $source = $form->like(lc $form->{subtransnono});
    $glwhere .= " AND lower(invoice_listing.subtransno) LIKE '$source'";
  }

  if ($form->{partnono}) {
    my $source = $form->like(lc $form->{partnono});
    $glwhere .= " AND lower(invoice_listing.partnumber) LIKE '$source'";
  }
  if ($form->{idescno}) {
    my $source = $form->like(lc $form->{idescno});
    $glwhere .= " AND lower(invoice_listing.description) LIKE '$source'";
  }
  if ($form->{loginno}) {
    my $source = $form->like(lc $form->{loginno});
    $glwhere .= " AND lower(invoice_listing.login) LIKE '$source'";
  }
  if ($form->{invnumber}) {
    my $source = $form->like(lc $form->{invnumber});
    $glwhere .= " AND lower(invoice_listing.invnumber) LIKE '$source'";
  }
  
    if ($form->{project}) {
    my $source = $form->like(lc $form->{project});
    $glwhere .= " AND lower(invoice_listing.project) LIKE '$source'";
  } 
  if ($form->{subb}) {
    my $source = $form->like(lc $form->{subb});
    $glwhere .= " AND lower(invoice_listing.subb) LIKE '$source'";
  }
  if ($form->{ordnumber}) {
    my $source = $form->like(lc $form->{ordnumber});
    $glwhere .= " AND lower(invoice_listing.ordnumber) LIKE '$source'";
  }
  if ($form->{datefrom}) {
    $glwhere .= " AND invoice_listing.transdate >= '$form->{datefrom}'";
  }
  if ($form->{dateto}) {
    $glwhere .= " AND invoice_listing.transdate <= '$form->{dateto}'";
  }
  
      if ($form->{make}) {
    my $make = $form->like(lc $form->{make}.":");
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$make')";
  }
  if ($form->{model}) {
    my $model = $form->like(lc ":".$form->{model});
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$model')";
  }
  #if ($form->{description}) {
  #  my $description = $form->like(lc $form->{description});
  #  $glwhere .= " AND lower(description) LIKE '$description'";
#    $arwhere .= " AND lower(customer.name) LIKE '$description'";
#    $apwhere .= " AND lower(vendor.name) LIKE '$description'";
  #}

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw( invnumber ordnumber transdate accno partnumber description qty price subtotal1 qtykg customer login ));
 # my %ordinal = ( transdate => 6,
 #                 invnumber => 4,
#		  accno => 5 );
 # map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  $sortorder = $form->{sort} .','. $sortorder;
 # $sortorder = $form->{sort} unless $sortorder;

#  my $query = qq|SELECT invoice_listing.*,curr from invoice_listing,ar where ar.id=invoice_listing.id and $glwhere
#	         ORDER BY $sortorder|;
  my $query = qq|select *,poqty-qty as pobalance from (


			select ar.invnumber, ar.transdate, ar.project, ar.subb, ar.transtype, ar.batch, ar.transno, ar.subtransno, ar.id
			,i.description,i.sellprice as price,i.qty,i.discount,i.unit,p.partnumber,p.onhand*p.weight as qtykg
			, i.sellprice*i.qty*(100-i.discount)/100 as subtotal1,i.delivery_date,i.remark2,i.parts_id,part_ordnumber as ordnumber
			, ar.customer_id,c.customernumber as accno , c.name as customer
			,(select sum(qty) as poqty from orderitems,oe where oe.id=orderitems.trans_id and oe.ordnumber=part_ordnumber) as poqty
			,(select login from employee where id=ar.employee_id) as login,i.tax
			
			from ar,invoice as i,parts as p,customer as c
			
			where ar.id=i.trans_id 
			and ar.customer_id = c.id
			and p.id=i.parts_id
			and assemblyitem='f'
			
			) as invoice_listing where $glwhere order by $sortorder;

|;
  my $sth = $dbh->prepare($query);
#$form->dberror($query);

  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
      $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }
   if($ref->{ordnumber}){

         #get Sales order
    $query = qq|select ordnumber as part_ordnumber, parts_id as ord_parts_id,qty as ord_parts_qty from oe,orderitems where vendor_id=0 and oe.id=orderitems.trans_id and ordnumber='$ref->{ordnumber}' and parts_id=$ref->{parts_id} |;
    my $sth = $dbh->prepare($query);
     $sth->execute || $form->dberror($query);


     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{ord_parts_id} = "$ptref->{ord_parts_id} ";
	$ref->{ord_parts_qty} = "$ptref->{ord_parts_qty} ";
      }

          #get last qty
    $query = qq|select part_ordnumber, parts_id as last_parts_id,sum(qty) as last_parts_qty from ar,invoice where  ar.id=invoice.trans_id and part_ordnumber='$ref->{ordnumber}' and parts_id=$ref->{parts_id} and trans_id < $ref->{id} group by part_ordnumber,parts_id |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);


     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{last_parts_id} .= "$ptref->{last_parts_id} ";
	$ref->{last_parts_qty} .= "$ptref->{last_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";
      }

  $lastqty=$ref->{"last_parts_qty"};
 $part_ordnumber =$ref->{"part_ordnumber"};
 $ord_parts_qty =  $ref->{"ord_parts_qty"};
  $last_balance=$ref->{"ord_parts_qty"}-$lastqty-$ref->{qty};
  #$po_details = "P/O NO : $part_ordnumber  <br> P/O QTY : $ord_parts_qty <br> Acc Qty Divd : $lastqty <br> P/O Balance : $last_balance";

   $ref->{pobalance}=$last_balance;
   $ref->{poqty}=$ref->{ord_parts_qty};
 $sth->finish;
}
    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

sub all_transactions_vendor {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
 ($customerno, $form->{customer1}) = split(/--/, $form->{vendorno});
  if ($form->{customer1}) {
    my $source = $form->like(lc $form->{customer1});
    $glwhere .= " AND lower(vendor_listing.vendor_id) LIKE '$source'";
  }
  if ($form->{parts_id}) {
 
	  $glwhere .= " AND vendor_listing.parts_id=$form->{parts_id}";
  }
    if ($form->{transtypeno}) {
    my $source = $form->like(lc $form->{transtypeno});
    $glwhere .= " AND lower(vendor_listing.transtype) LIKE '$source'";
  }  if ($form->{batchno}) {
    my $source = $form->like(lc $form->{batchno});
    $glwhere .= " AND lower(vendor_listing.batch) LIKE '$source'";
  }  if ($form->{transnono}) {
    my $source = $form->like(lc $form->{transnono});
    $glwhere .= " AND lower(vendor_listing.transno) LIKE '$source'";
  }  if ($form->{subtransnono}) {
    my $source = $form->like(lc $form->{subtransnono});
    $glwhere .= " AND lower(vendor_listing.subtransno) LIKE '$source'";
  }
  if ($form->{partnono}) {
    my $source = $form->like(lc $form->{partnono});
    $glwhere .= " AND lower(vendor_listing.partnumber) LIKE '$source'";
  }
  if ($form->{idescno}) {
    my $source = $form->like(lc $form->{idescno});
    $glwhere .= " AND lower(vendor_listing.description) LIKE '$source'";
  }
  if ($form->{loginno}) {
    my $source = $form->like(lc $form->{loginno});
    $glwhere .= " AND lower(vendor_listing.login) LIKE '$source'";
  }
 if ($form->{datefrom}) {
    $glwhere .= " AND vendor_listing.transdate >= '$form->{datefrom}'";
  }
  if ($form->{dateto}) {
    $glwhere .= " AND vendor_listing.transdate <= '$form->{dateto}'";
  }
    if ($form->{invnumber}) {
    my $source = $form->like(lc $form->{invnumber});
    $glwhere .= " AND lower(vendor_listing.invnumber) LIKE '$source'";
  }
  if ($form->{ordnumber}) {
    my $source = $form->like(lc $form->{ordnumber});
    $glwhere .= " AND lower(vendor_listing.ordnumber) LIKE '$source'";
  }

    if ($form->{project}) {
    my $source = $form->like(lc $form->{project});
    $glwhere .= " AND lower(vendor_listing.project) LIKE '$source'";
  } 
  if ($form->{subb}) {
    my $source = $form->like(lc $form->{subb});
    $glwhere .= " AND lower(vendor_listing.subb) LIKE '$source'";
  }
      if ($form->{make}) {
    my $make = $form->like(lc $form->{make}.":");
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$make')";
  }
  if ($form->{model}) {
    my $model = $form->like(lc ":".$form->{model});
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$model')";
  }
  #if ($form->{description}) {
  #  my $description = $form->like(lc $form->{description});
  #  $glwhere .= " AND lower(description) LIKE '$description'";
#    $arwhere .= " AND lower(customer.name) LIKE '$description'";
#    $apwhere .= " AND lower(vendor.name) LIKE '$description'";
  #}

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw(invnumber ordnumber transdate accno partnumber description qty price subtotal1 qtykg customer login ));
  $sortorder = $form->{sort} .','. $sortorder;

  #my $query = qq|SELECT vendor_listing.*,  curr from vendor_listing,ap where vendor_listing.id=ap.id and $glwhere
 #	         ORDER BY $sortorder,partnumber,transdate|;

my $query = qq|		 
		select *,poqty-qty as pobalance from (
		
		
		select ap.invnumber, ap.transdate, ap.project, ap.subb, ap.transtype, ap.batch, ap.transno, ap.subtransno, ap.id
		,i.description,i.sellprice as price,i.qty,i.discount,i.unit,p.partnumber,p.onhand*p.weight as qtykg
		, i.sellprice*i.qty*(100-i.discount)/100 as subtotal1,i.delivery_date,i.remark2,i.parts_id,part_ordnumber as ordnumber
		, ap.vendor_id,c.vendornumber as accno , c.name as customer
		,(select sum(qty) as poqty from orderitems,oe where oe.id=orderitems.trans_id and oe.ordnumber=part_ordnumber) as poqty
		,(select login from employee where id=ap.employee_id) as login,i.tax
		
		from ap,invoice as i,parts as p,vendor as c
		
		where ap.id=i.trans_id 
		and ap.vendor_id = c.id
		and p.id=i.parts_id
		and assemblyitem='f'
		) as vendor_listing where $glwhere order by $sortorder;
		
|;
my $sth = $dbh->prepare($query);


  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
      $ref->{credit} = $ref->{subtotal};
      $ref->{qty} = $ref->{qty}*-1;
      $ref->{subtotal1} = $ref->{subtotal1}*-1;
   #   $ref->{debit} = 0;
   # }

   if($ref->{ordnumber}){
    ($transtype,$part_ordnumber) = split(/:/, $ref->{"ordnumber"});

         #get Sales order
    $query = qq|select ordnumber as part_ordnumber, parts_id as ord_parts_id,qty as ord_parts_qty from oe,orderitems where customer_id=0 and oe.id=orderitems.trans_id and ordnumber='$part_ordnumber' and transtype='$transtype' and parts_id=$ref->{parts_id} |;
    my $sth = $dbh->prepare($query);
     $sth->execute || $form->dberror($query);


     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{ord_parts_id} = "$ptref->{ord_parts_id} ";
	$ref->{ord_parts_qty} = "$ptref->{ord_parts_qty} ";
      }

          #get last qty
    $query = qq|select part_ordnumber, parts_id as last_parts_id,sum(qty) as last_parts_qty from ap,invoice where  ap.id=invoice.trans_id and part_ordnumber='$ref->{ordnumber}' and parts_id=$ref->{parts_id} and trans_id < $ref->{id} group by part_ordnumber,parts_id |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);


     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{last_parts_id} .= "$ptref->{last_parts_id} ";
	$ref->{last_parts_qty} .= "$ptref->{last_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";
      }

  $lastqty=$ref->{"last_parts_qty"};
 $part_ordnumber =$ref->{"part_ordnumber"};
 $ord_parts_qty =  $ref->{"ord_parts_qty"};
  $last_balance=$ref->{"ord_parts_qty"}+$lastqty-$ref->{qty};
  #$po_details = "P/O NO : $part_ordnumber  <br> P/O QTY : $ord_parts_qty <br> Acc Qty Divd : $lastqty <br> P/O Balance : $last_balance";

   $ref->{pobalance}=$last_balance;
   $ref->{poqty}=$ref->{ord_parts_qty};
 $sth->finish;
}



   push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}


sub all_transactions_sales {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
 ($customerno, $form->{customer1}) = split(/--/, $form->{customerno});
  if ($form->{customer1}) {
    my $source = $form->like(lc $form->{customer1});
    $glwhere .= " AND lower(sales_listing.customer_id) LIKE '$source'";
  }
    if ($form->{transtypeno}) {
    my $source = $form->like(lc $form->{transtypeno});
    $glwhere .= " AND lower(sales_listing.transtype) LIKE '$source'";
  }  
  if ($form->{partnono}) {
    my $source = $form->like(lc $form->{partnono});
    $glwhere .= " AND lower(sales_listing.partnumber) LIKE '$source'";
  }
  if ($form->{idescno}) {
    my $source = $form->like(lc $form->{idescno});
    $glwhere .= " AND lower(sales_listing.description) LIKE '$source'";
  }
  if ($form->{loginno}) {
    my $source = $form->like(lc $form->{loginno});
    $glwhere .= " AND lower(sales_listing.login) LIKE '$source'";
  }
 if ($form->{datefrom}) {
    $glwhere .= " AND sales_listing.transdate >= '$form->{datefrom}'";
  }
  if ($form->{dateto}) {
    $glwhere .= " AND sales_listing.transdate <= '$form->{dateto}'";
  }
      if ($form->{invnumber}) {
    my $source = $form->like(lc $form->{invnumber});
    $glwhere .= " AND lower(sales_listing.invnumber) LIKE '$source'";
  }
  if ($form->{ordnumber}) {
    my $source = $form->like(lc $form->{ordnumber});
    $glwhere .= " AND lower(sales_listing.invnumber) LIKE '$source'";
  }

        if ($form->{make}) {
    my $make = $form->like(lc $form->{make}.":");
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$make')";
  }
  if ($form->{model}) {
    my $model = $form->like(lc ":".$form->{model});
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$model')";
  }
  #if ($form->{description}) {
  #  my $description = $form->like(lc $form->{description});
  #  $glwhere .= " AND lower(description) LIKE '$description'";
#    $arwhere .= " AND lower(customer.name) LIKE '$description'";
#    $apwhere .= " AND lower(vendor.name) LIKE '$description'";
  #}

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw(invnumber ordnumber transdate accno partnumber description qty price subtotal1 qtykg customer login ));
  $sortorder = $form->{sort} .','. $sortorder;

 # my $query = qq|SELECT sales_listing.*,invnumber as ordnumber,curr from sales_listing,oe where oe.id=sales_listing.id and $glwhere
#	         ORDER BY $sortorder,partnumber,transdate|;
  my $query = qq|
		select *,poqty-qty as pobalance from (
		
		
		select ap.ordnumber as invnumber, ap.transdate, '' as project, '' as subb, ap.transtype, '' as batch, '' as transno, '' as subtransno, ap.id
		,i.description,i.sellprice as price,i.qty,i.discount,i.unit,p.partnumber,p.onhand*p.weight as qtykg
		, i.sellprice*i.qty*(100-i.discount)/100 as subtotal1,i.delivery_date,i.remark2,i.parts_id, ordnumber
		, ap.customer_id,c.customernumber as accno , c.name as customer
		,0 as poqty
		,(select login from employee where id=ap.employee_id) as login,i.tax
		
		from oe as ap,orderitems as i,parts as p,customer as c
		
		where ap.id=i.trans_id 
		and ap.customer_id = c.id
		and p.id=i.parts_id
		
		) as sales_listing   where $glwhere  order by $sortorder;

|;
my $sth = $dbh->prepare($query);

#$form->dberror($form->{make});
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
      $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }

    if($ref->{ordnumber}){

         #get Sales order
    $query = qq|select ordnumber as part_ordnumber, parts_id as ord_parts_id,qty as ord_parts_qty from oe,orderitems where vendor_id=0 and oe.id=orderitems.trans_id and ordnumber='$ref->{ordnumber}' and parts_id=$ref->{parts_id} and trans_id <= $ref->{id}|;
    my $sth = $dbh->prepare($query);
     $sth->execute || $form->dberror($query);
#$form->dberror($query);

     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{ord_parts_id} = "$ptref->{ord_parts_id} ";
	$ref->{ord_parts_qty} = "$ptref->{ord_parts_qty} ";
      }

          #get last qty
    $query = qq|select part_ordnumber , parts_id as last_parts_id,sum(qty) as last_parts_qty from ar,invoice where  ar.id=invoice.trans_id and part_ordnumber='$ref->{ordnumber}' and parts_id=$ref->{parts_id}  group by part_ordnumber,parts_id |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);


     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{last_parts_id} .= "$ptref->{last_parts_id} ";
	$ref->{last_parts_qty} .= "$ptref->{last_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";
      }

  $lastqty=$ref->{"last_parts_qty"};
 $part_ordnumber =$ref->{"part_ordnumber"};
 $ord_parts_qty =  $ref->{"ord_parts_qty"};
  $last_balance=$ref->{"ord_parts_qty"}-$lastqty;
  #$po_details = "P/O NO : $part_ordnumber  <br> P/O QTY : $ord_parts_qty <br> Acc Qty Divd : $lastqty <br> P/O Balance : $last_balance";

   $ref->{pobalance}=$last_balance;
   $ref->{poqty}=$ref->{ord_parts_qty};
 $sth->finish;
}
    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}


sub all_transactions_purchase {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");
 ($customerno, $form->{customer1}) = split(/--/, $form->{vendorno});
  if ($form->{customer1}) {
    my $source = $form->like(lc $form->{customer1});
    $glwhere .= " AND lower(purchase_listing.customer_id) LIKE '$source'";
  }
    if ($form->{transtypeno}) {
    my $source = $form->like(lc $form->{transtypeno});
    $glwhere .= " AND lower(purchase_listing.transtype) LIKE '$source'";
  }  
  if ($form->{partnono}) {
    my $source = $form->like(lc $form->{partnono});
    $glwhere .= " AND lower(purchase_listing.partnumber) LIKE '$source'";
  }
  if ($form->{idescno}) {
    my $source = $form->like(lc $form->{idescno});
    $glwhere .= " AND lower(purchase_listing.description) LIKE '$source'";
  }
  if ($form->{loginno}) {
    my $source = $form->like(lc $form->{loginno});
    $glwhere .= " AND lower(purchase_listing.login) LIKE '$source'";
  }
 if ($form->{datefrom}) {
    $glwhere .= " AND purchase_listing.transdate >= '$form->{datefrom}'";
  }
  if ($form->{dateto}) {
    $glwhere .= " AND purchase_listing.transdate <= '$form->{dateto}'";
  }
        if ($form->{invnumber}) {
    my $source = $form->like(lc $form->{invnumber});
    $glwhere .= " AND lower(purchase_listing.invnumber) LIKE '$source'";
  }
  if ($form->{ordnumber}) {
    my $source = $form->like(lc $form->{ordnumber});
    $glwhere .= " AND lower(purchase_listing.invnumber) LIKE '$source'";
  }
  
        if ($form->{make}) {
    my $make = $form->like(lc $form->{make}.":");
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$make')";
  }
  if ($form->{model}) {
    my $model = $form->like(lc ":".$form->{model});
    $glwhere .= " AND parts_id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$model')";
  }
  #if ($form->{description}) {
  #  my $description = $form->like(lc $form->{description});
  #  $glwhere .= " AND lower(description) LIKE '$description'";
#    $arwhere .= " AND lower(customer.name) LIKE '$description'";
#    $apwhere .= " AND lower(vendor.name) LIKE '$description'";
  #}

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw(invnumber  ordnumber transdate accno partnumber description qty price subtotal1 qtykg customer login ));
  $sortorder = $form->{sort} .','. $sortorder;

#  my $query = qq|SELECT purchase_listing.*,invnumber as ordnumber,curr from purchase_listing,oe where oe.id=purchase_listing.id and $glwhere
#	         ORDER BY $sortorder|;

my $query = qq|
select *,poqty-qty as pobalance from (
			select ap.ordnumber as invnumber, ap.transdate, '' as project, '' as subb, ap.transtype, '' as batch, '' as transno, '' as subtransno, ap.id
			,i.description,i.sellprice as price,i.qty,i.discount,i.unit,p.partnumber,p.onhand*p.weight as qtykg
			, i.sellprice*i.qty*(100-i.discount)/100 as subtotal1,i.delivery_date,i.remark2,i.parts_id, ordnumber
			, ap.vendor_id,c.vendornumber as accno , c.name as customer
			,0 as poqty
			,(select login from employee where id=ap.employee_id) as login,i.tax
			
			from oe as ap,orderitems as i,parts as p,vendor as c
			
			where ap.id=i.trans_id 
			and ap.vendor_id = c.id
			and p.id=i.parts_id
			
			) as purchase_listing  where $glwhere order by $sortorder;
|;		 
		 
my $sth = $dbh->prepare($query);


  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

   # if ($ref->{amount} < 0) {
   #   $ref->{debit} = $ref->{subtotal} * -1;
   #   $ref->{credit} = 0;
   # } else {
      $ref->{credit} = $ref->{subtotal};
   #   $ref->{debit} = 0;
   # }

   if($ref->{ordnumber}){

         #get Sales order
    $query = qq|select ordnumber as part_ordnumber, parts_id as ord_parts_id,qty as ord_parts_qty from oe,orderitems where customer_id=0 and oe.id=orderitems.trans_id and ordnumber='$ref->{ordnumber}' and parts_id=$ref->{parts_id} and trans_id <= $ref->{id}|;
    my $sth = $dbh->prepare($query);
     $sth->execute || $form->dberror($query);
#$form->dberror($query);

     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{ord_parts_id} = "$ptref->{ord_parts_id} ";
	$ref->{ord_parts_qty} = "$ptref->{ord_parts_qty} ";
      }

          #get last qty
    $query = qq|select  part_ordnumber, parts_id as last_parts_id,sum(qty) as last_parts_qty from ap,invoice where  ap.id=invoice.trans_id and part_ordnumber='$ref->{ordnumber}' and parts_id=$ref->{parts_id}  group by part_ordnumber,parts_id |;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);


     while (my $ptref = $sth->fetchrow_hashref(NAME_lc)) {
	$ref->{last_parts_id} .= "$ptref->{last_parts_id} ";
	$ref->{last_parts_qty} .= "$ptref->{last_parts_qty} ";
	#$ref->{part_ordnumber} .= "$ptref->{part_ordnumber} ";
      }

  $lastqty=$ref->{"last_parts_qty"};
 $part_ordnumber =$ref->{"part_ordnumber"};
 $ord_parts_qty =  $ref->{"ord_parts_qty"};
  $last_balance=$ref->{"ord_parts_qty"}+$lastqty;
  #$po_details = "P/O NO : $part_ordnumber  <br> P/O QTY : $ord_parts_qty <br> Acc Qty Divd : $lastqty <br> P/O Balance : $last_balance";

   $ref->{pobalance}=$last_balance;
   $ref->{poqty}=$ref->{ord_parts_qty};
 $sth->finish;
}



    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

1;
