#!/bin/sh

## 引数解析
## -a   全てのテストを行う
## 数字 指定されたテストを行う。

check_cluster()
{
	echo "tbl_cluster1" 2>&1  | tee -a test.out
	psql -c "SELECT * FROM tbl_cluster1;" -d $1 2>&1  | tee -a test.out
	psql -c "SELECT relfilenode FROM pg_class WHERE relname='tbl_cluster1';" -d $1 2>&1  | tee -a test.out
	
	echo "tbl_cluster2" 2>&1  | tee -a test.out
	psql -c "SELECT * FROM tbl_cluster2;" -d $1 2>&1  | tee -a test.out
	psql -c "SELECT relfilenode FROM pg_class WHERE relname='tbl_cluster2';" -d $1 2>&1  | tee -a test.out

	echo "tbl_ckey_only" 2>&1  | tee -a test.out
	psql -c "SELECT * FROM tbl_ckey_only;" -d $1 2>&1  | tee -a test.out
	psql -c "SELECT relfilenode FROM pg_class WHERE relname='tbl_ckey_only';" -d  $1 2>&1  | tee -a test.out

	echo "tbl_pkey_only" 2>&1  | tee -a test.out
	psql -c "SELECT * FROM tbl_pkey_only;" -d $1 2>&1  | tee -a test.out
	psql -c "SELECT relfilenode FROM pg_class WHERE relname='tbl_pkey_only';" -d $1 2>&1  | tee -a test.out
}

create_testDB()
{
	target=$1
	createdb  $target 2>&1  | tee -a test.out
	psql -e -f ./create_tables.sql -d $target
	check_cluster $target 2>&1  | tee -a test.out
	
}

drop_testDB()
{
	target=$1
	check_cluster $target
	dropdb $target 2>&1  | tee -a test.out
}

### オプションなし
test_1()
{


	echo "pg_reorg [not option]"
	create_testDB test
	pg_reorg 2>&1  | tee -a test.out
	drop_testDB test
}

### -all
test_2()
{

	echo "pg_reorg [--all DB]"
	create_testDB test
	pg_reorg --all 2>&1  | tee -a test.out
	drop_testDB test
}

### -a
test_3()
{

	echo "pg_reorg [-a]"
	create_testDB test
	pg_reorg -a 2>&1  | tee -a test.out
	drop_testDB test
}

### --dbname
test_4()
{

	echo "pg_reorg [--dbname]"
	create_testDB test2
	pg_reorg --dbname test2 2>&1  | tee -a test.out
	drop_testDB test2
}

### -d
test_5()
{

	echo "pg_reorg [-d]"
	create_testDB test2
	pg_reorg --d test2 2>&1  | tee -a test.out
	drop_testDB test2

}

### --table
test_6()
{


	echo "pg_reorg [--table]"
	create_testDB test
	pg_reorg --table tbl_cluster1 2>&1  | tee -a test.out
	drop_testDB test
}

### -t
test_7()
{
	### -t

	echo "pg_reorg [-t]"
	create_testDB test
	pg_reorg -t tbl_cluster1 2>&1  | tee -a test.out
	drop_testDB test
}

### -d、-t
test_8()
{
	### -d、-t

	echo "pg_reorg [-d,-t]"
	create_testDB test
	pg_reorg -d test -t tbl_cluster1 2>&1  | tee -a test.out
	drop_testDB test

}

### -e
test_9()
{
	### -e

	echo "pg_reorg [-e]"
	create_testDB test
	pg_reorg -e 2>&1  | tee -a test.out
	drop_testDB test
}

### -v
test_10()
{
	### -v

	echo "pg_reorg [-v]"
	create_testDB test
	pg_reorg -v 2>&1  | tee -a test.out
	drop_testDB test
}

### -q
test_11()
{

	echo "pg_reorg [-q]"
	create_testDB test
	pg_reorg -q 2>&1  | tee -a test.out
	drop_testDB test
}

### -n
test_12()
{

	echo "pg_reorg [-n]"
	create_testDB test
	pg_reorg -n 2>&1  | tee -a test.out
	drop_testDB test
}

### -o database【異常系】
test_13()
{

	echo "pg_reorg [-o database (error-case)]"
	create_testDB test
	pg_reorg -o test 2>&1  | tee -a test.out
	drop_testDB test
}

### -o table【異常系】
test_14()
{

	echo "pg_reorg [-o table (error-case)]"
	create_testDB test
	pg_reorg -o tbl_cluster1 2>&1  | tee -a test.out
	drop_testDB test
}

### -o column
test_15()
{

	echo "pg_reorg [-o colomn]"
	create_testDB test
	pg_reorg -o col1 2>&1  | tee -a test.out
	drop_testDB test
}

### --help
test_16()
{

	echo "pg_reorg [--help]"
	pg_reorg --help 2>&1  | tee -a test.out
}

### -h【異常系】
test_17()
{

	echo "pg_reorg [-h (error-case)]"
	pg_reorg -h 2>&1  | tee -a test.out
}

### --version
test_18()
{

	echo "pg_reorg [--version]"
	pg_reorg --version 2>&1  | tee -a test.out

}

### -v 【異常系】
test_19()
{

	echo "pg_reorg [-v (error-case)]"
	pg_reorg -v 2>&1  | tee -a test.out
}

### --echo
test_20()
{

	echo "pg_reorg [--echo]"
	create_testDB test
	pg_reorg --echo 2>&1  | tee -a test.out
	drop_testDB test
}

### --verbose
test_21()
{

	echo "pg_reorg [--verbose]"
	create_testDB test
	pg_reorg --verbose 2>&1  | tee -a test.out
	drop_testDB test
}

### --quiet
test_22()
{

	echo "pg_reorg [--quiet]"
	create_testDB test
	pg_reorg --quiet 2>&1  | tee -a test.out
	drop_testDB test
}

### -h(引数あり：ホスト名)
test_23()
{

	echo "pg_reorg [-h]"
	create_testDB test
	pg_reorg -h $1 2>&1  | tee -a test.out
	drop_testDB test
}

### --host(引数あり：ホスト名)
test_24()
{

	echo "pg_reorg [-host]"
	create_testDB test
	pg_reorg --host $1 2>&1  | tee -a test.out
	drop_testDB test
}

### -p(引数あり：ポート)
test_25()
{

	echo "pg_reorg [-p]"
	create_testDB test
	pg_reorg -p $1 2>&1  | tee -a test.out
	drop_testDB test
}

### --port(引数あり：ポート)
test_26()
{

	echo "pg_reorg [-port]"
	create_testDB test
	pg_reorg --port $1 2>&1  | tee -a test.out
	drop_testDB test
}

### --username(引数あり：ユーザ名)
test_27()
{

	echo "pg_reorg [--username]"
	create_testDB test
	pg_reorg --username $1 2>&1  | tee -a test.out
	drop_testDB test
}

### -U(引数あり：ユーザ名)
test_28()
{

	echo "pg_reorg [-U]"
	create_testDB test
	pg_reorg -U $1 2>&1  | tee -a test.out
	drop_testDB test
}

### --password
test_29()
{

	echo "pg_reorg [--password]"
	create_testDB test
	pg_reorg --password 2>&1  | tee -a test.out
	drop_testDB test
}

### -W
test_30()
{

	echo "pg_reorg [-W]"
	create_testDB test
	pg_reorg -W 2>&1  | tee -a test.out
	drop_testDB test
}

### --no-order 
test_31()
{

	echo "pg_reorg [--no-order]"
	create_testDB test
	pg_reorg --no-order 2>&1  | tee -a test.out
	drop_testDB test
}

### --order-by colomn(引数あり：カラム名）
test_32()
{

	echo "pg_reorg [--order-by]"
	create_testDB test 
	pg_reorg --order-by col1 2>&1  | tee -a test.out
	drop_testDB test
}

### --dbname 複数
test_33()
{

	echo "pg_reorg [--dbname:Repetition]"
	create_testDB test 
	pg_reorg --dbname postgres -d test 2>&1  | tee -a test.out
	drop_testDB test
}

### PGDATABASE あり、PGUSERなし
test_34()
{

	echo "pg_reorg [notPGDATABASE、PGUSER]"
	pg_ctl stop
	sleep 10
	cp /home/tokutake/.bashrc-no34 /home/tokutake/.bashrc
	source /home/tokutake/.bashrc
	pg_ctl start 
	sleep 20
	create_testDB test 
	pg_reorg -e 2>&1  | tee -a test.out
	drop_testDB test
	cp /home/tokutake/.bashrc-test /home/tokutake/.bashrc
	source /home/tokutake/.bashrc
}



export NOWDIR="`pwd`"
FILE_LIST="${NOWDIR}/listfile"

#
# ・コマンド引数が指定されている場合、引数に指定された試験を実行する (複数指定可能)
#
#まだ未実装↓
# ・コマンド引数が指定されていない場合、「listfile」に列挙された試験を実行する
#
item_number=()

if [ ${#@} -ne 0 ] ; then
	item_number=("${@}")
else
	item_number=(`cat ${FILE_LIST} | grep -Pv '^\s*#.*' | grep -Pv '^\s*$'`)
fi

for number in "${item_number[@]}"
do
	export PTNDIR="${NOWDIR}/${number}"
	
	$number
	
	sleep 1
done

exit 0

