#!/bin/bash
# Copyright (C) 2013 Tomasz Olszak <olszak.tomasz@gmail.com>
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:

# 1. Redistributions of source code must retain the copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products 
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

function usage {
  echo -e "\n"
  echo "Script for Qt for tizen compilation. Should be invoked from shadowbuild directory."
  echo "Set Parameters or environment variables with absolute paths"
  echo ""
  echo "Usage:"
  echo "./compile_tizenemulator.sh \$QT5SRCDIR \$TIZENSYSROOT \$TIZENSDKSYSROOT \$TIZENSDKCOMPILERDIR \$HOSTPREFIX"
  echo ""
  echo "QT5SRCDIR - directory with qt5 sources"
  echo "TIZENSYSROOT - sysroot created from emulator devel headers and libraries - by default qt will be installed in \$TIZENSYSROOT/opt/usr/qt5"
  echo "TIZENSDKSYSROOT - should be set to tizen-sdk/platforms/tizen2.1/rootstraps/tizen-emulator-2.1.native"
  echo "TIZENSDKCOMPILERDIR - should be set to tizen-sdk/tools/i386-linux-gnueabi-gcc-4.5 "
  echo "HOSTPREFIX - here qmake and other host binaries will be installed"
  echo "If corresponding environment variables are set then script can be invoked without parameters"
  echo ""
  exit;
}

if [ "$1" == "-h" ]; then
  usage
fi

function checkEnvironment {
  echo ""
  if [ ! -f $QT5SRCDIR/configure ]; then
     echo "incorrect Qt src path - file \$QT5SRCDIR/configure does not exist"
     usage
  fi
  if [ ! -f $TIZENSYSROOT/usr/include/linux/futex.h ]; then
     echo "incorrect Tizen sysroot path - file \$TIZENSYSROOT/usr/include/linux/futex.h does not exist"
     usage
  fi
  if [ ! -d $TIZENSDKSYSROOT/usr/lib/osp ]; then
     echo "incorrect Tizen sdk sysroot path - directory \$TIZENSDKSYSROOT/usr/lib/osp does not exist"
     usage
  fi
  if [ ! -d $TIZENSDKSYSROOT/usr/lib/osp ]; then
     echo "incorrect Tizen sdk sysroot path - directory \$TIZENSDKSYSROOT/usr/lib/osp does not exist"
     usage
  fi
  if [ ! -f $TIZENSDKCOMPILERDIR/bin/i386-linux-gnueabi-gcc ]; then
     echo "incorrect Tizen sdk compiler dir - file \$TIZENSDKCOMPILERDIR/bin/i386-linux-gnueabi-gcc does not exist"
     usage
  fi
}

if [ "$QT5SRCDIR" == "" ]; then
  QT5SRCDIR=$1
fi

if [ "$TIZENSYSROOT" == "" ]; then
  TIZENSYSROOT=$2
fi

if [ "$TIZENSDKSYSROOT" == "" ]; then
  TIZENSDKSYSROOT=$3
fi
if [ "$TIZENSDKCOMPILERDIR" == "" ]; then
  TIZENSDKCOMPILERDIR=$4
fi

if [ "$HOSTPREFIX" == "" ]; then
  HOSTPREFIX=$5
fi

if [ -z "$QT5SRCDIR" -o -z "$TIZENSYSROOT" -o -z "$TIZENSDKSYSROOT" \
     -o -z "$TIZENSDKCOMPILERDIR" -o -z "$HOSTPREFIX" ]; then
  usage
fi

checkEnvironment

echo "Configuration QT5SRCDIR=$QT5SRCDIR, TIZENSYSROOT=$TIZENSYSROOT, \
TIZENSDKSYSROOT=$TIZENSDKSYSROOT, TIZENSDKCOMPILERDIR=$TIZENSDKCOMPILERDIR, \
HOSTPREFIX=$HOSTPREFIX"

export PKG_CONFIG_LIBDIR=$TIZENSYSROOT/usr/lib
export PKG_CONFIG_SYSROOT_DIR=$TIZENSYSROOT
export PKG_CONFIG_PATH=$TIZENSYSROOT/usr/lib/pkgconfig

echo "preparing ROOTFS"

curDir=`pwd`
cd $TIZENSYSROOT
find -L . -type d -exec chmod 777 {} +
cp -ru $TIZENSDKSYSROOT/* $TIZENSYSROOT
rm -rf usr/lib/debug
find -L . -type l | while read -r file; do
    echo "fixing $file because is orphaned"
    link=$(readlink -qn $file)
    ln -fs $TIZENSYSROOT$link $file
done

cd $curDir
echo configuring Qt

$QT5SRCDIR/configure -hostprefix $HOSTPREFIX -v -release -opengl es2 -opensource \
    -confirm-license -make libs -device linux-tizenemulator-g++ \
    -device-option CROSS_COMPILE=$TIZENSDKCOMPILERDIR/bin/i386-linux-gnueabi- \
    -prefix /opt/usr/qt5 -sysroot $TIZENSYSROOT -nomake exmaples -nomake demos \
    -no-dbus -nomake docs -nomake tools -no-pch -qpa xcb -system-libpng -qt-xcb \
    -no-widgets -no-eglfs

if [ "$?" != "0" ]; then
  echo "Qt configuration error"
  exit;
fi;

make
mkdir -p qtdeclarative/tools/qmlscene
cd qtdeclarative/tools/qmlscene
../../../qtbase/bin/qmake ../../../../../qt5Gitorious/qtdeclarative/tools/qmlscene/
make install
cd ../../../
make install
