#!/bin/bash
# Copyright (C) 2013 Tomasz Olszak <olszak.tomasz@gmail.com>
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:

# 1. Redistributions of source code must retain the copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products 
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

packages_url=http://download.tizen.org/snapshots/2.1-emul/common/latest/repos/tizen-base/ia32/packages
wget -qbN -r -l 1 $packages_url/i586
wget -qbN -r -l 1 $packages_url/i686
wget -qbN -r -l 1 $packages_url/noarch
wget -qbN -r -l 1 $packages_url/repodata

packages_url=http://download.tizen.org/snapshots/2.1-emul/common/latest/repos/tizen-main/ia32/packages
wget -qbN -r -l 1  $packages_url/i586
wget -qbN -r -l 1  $packages_url/noarch
wget -qbN -r -l 1  $packages_url/repodata

count=0
while [ $(pgrep -c wget) -gt 0 ]; do
    if [ $(($count%60)) -eq 0 ]; then
        numberOfProcesses=$(pgrep -c wget)
        echo "still waiting for $numberOfProcesses wget processes to end";
    fi
    sleep 1
    (( count++ ))
done

echo "Download finished!"

find . -name 'index.html*' -exec rm {} +
mkdir repos
mv download.tizen.org/snapshots/2.1-emul/common/latest/repos/tizen-* repos/
rm -rf download.tizen.org

echo "Tizen emulator repositories ready"
