#!/bin/bash
# Copyright (C) 2013 Tomasz Olszak <olszak.tomasz@gmail.com>
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:

# 1. Redistributions of source code must retain the copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products 
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

zypper -q rr Tizen-main
zypper -q rr Tizen-base
sed -i "s/# arch = s390/arch = i586/" /etc/zypp/zypp.conf
#needed for Qt 5.1 and xkb support
su -c "ln -sf /etc/X11/xkb /usr/share/X11/xkb"

zypper -q ar /mnt/host/repos/tizen-main/ia32/packages Tizen-main-latest
zypper -q ar /mnt/host/repos/tizen-base/ia32/packages Tizen-base-latest
zypper -q refresh

zypper --non-interactive in libX11-devel glib2-devel libicu-devel simulator-opengl-devel \
    kernel-headers libpng-devel zlib-devel fontconfig-devel freetype-devel libXext-devel \
    libXi-devel libXrender-devel

mkdir -p /mnt/host/rootfs/lib
mkdir -p /mnt/host/rootfs/usr/local


echo "syncing rootfs /lib"
cp -ru /lib /mnt/host/rootfs/
echo "syncing rootfs /usr"
cp -ru /usr/include  /usr/lib  /usr/libexec  /mnt/host/rootfs/usr/
echo "syncing rootfs /usr/local"
cp -ru /usr/local/include /usr/local/lib /usr/local/libexec  /mnt/host/rootfs/usr/local
