#!/bin/bash
# Copyright (C) 2013 Tomasz Olszak <olszak.tomasz@gmail.com>
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:

# 1. Redistributions of source code must retain the copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products 
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

set -e

if [ -z "$TIZEN_VERSION" -o -z "$CROSS_COMPILE_FOR" ]; then
    echo "download_repos: Unset obligatory variables: TIZEN_VERSION, CROSS_COMPILE_FOR"
    exit 1
fi



if [ "$CROSS_COMPILE_FOR" == "emulator" ]; then
    SIZE_IN_MB=827
    TARGET_NAME=$TIZEN_VERSION-emul
    base_packages_url=http://download.tizen.org/snapshots/$TARGET_NAME/common/latest/repos/tizen-base/ia32/packages    
    main_packages_url=http://download.tizen.org/snapshots/$TARGET_NAME/common/latest/repos/tizen-main/ia32/packages
    base_parts="i586 i686 noarch repodata"
    main_parts="i586 noarch repodata"
else 
    SIZE_IN_MB=839
    TARGET_NAME=$TIZEN_VERSION    
    base_packages_url=http://download.tizen.org/snapshots/$TARGET_NAME/common/latest/repos/tizen-base/armv7l/packages
    main_packages_url=http://download.tizen.org/snapshots/$TARGET_NAME/common/latest/repos/tizen-main/armv7l/packages
    base_parts="armv7l noarch repodata"
    main_parts="armv7l noarch repodata"
fi

for part in $base_parts; do
    wget -qbN -r -l 1 $base_packages_url/$part
done

for part in $main_parts; do
    wget -qbN -r -l 1 $main_packages_url/$part
done

set +e

count=0
LAST_PERCENT=0
while [ $(pgrep -c wget) -gt 0 ]; do
    if [ $(($count%5)) -eq 0 ]; then
        if [ -d download.tizen.org ]; then
            CUR_SIZE=$(du -sh download.tizen.org | grep -Eo "^[0-9]+")            
            percentCompleted=$(echo "100.0 * $CUR_SIZE / $SIZE_IN_MB" | bc  )
            if [ "$LAST_PERCENT" != "$percentCompleted" ]; then
                echo "Percent completed: $percentCompleted"
                LAST_PERCENT=$percentCompleted
            fi
        fi          
    fi
    sleep 1
    (( count++ ))
done

set -e

echo "Download finished!"

find . -name 'index.html*' -exec rm {} +
mkdir repos
mv download.tizen.org/snapshots/$TARGET_NAME/common/latest/repos/tizen-* repos/
rm -rf download.tizen.org

echo "Tizen repositories ready"
