#!/bin/bash
# Copyright (C) 2013 Tomasz Olszak <olszak.tomasz@gmail.com>
# All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:

# 1. Redistributions of source code must retain the copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products 
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

set -e

CURRENT_DIR=$(pwd)

SCRIPT_DIR=$(dirname $0)

cd $SCRIPT_DIR

function usage {
    echo -e "\n"
    echo "Script for Qt for tizen compilation. "
    echo "Set Parameters or environment variables with absolute paths"
    echo ""
    echo "Usage:"
    echo "sudo [MAKE_THREADS=numberOfCPUCores] [QT5SRCDIR=Qt5SrcPath] [INSTALLDIR=QtInstallPrefix] ./downloadAndBuildAll.sh"
    echo ""
    echo "QT5SRCDIR - directory with qt5 sources"
    echo "INSTALLDIR - here qmake and other host binaries will be installed"
    echo "If corresponding environment variables are set then script can be invoked without parameters"
    echo "set MAKE_THREADS environment variable to number of your CPU cores to fast up compilation step"    
    echo ""
    cd $CURRENT_DIR
    exit;
}

if [ "$1" == "-h" -o "$1" == "--help" ]; then
    usage
fi

if [ "$QT5SRCDIR" == "" ]; then
    QT5SRCDIR=$PWD/qt5.gitorious
    echo "Setting QT5SRCDIR to $QT5SRCDIR"
fi

if [ "$INSTALLDIR" == "" ]; then
    INSTALLDIR=$PWD/qt5hostInstall
    echo "Setting INSTALLDIR to $INSTALLDIR"
fi

if [ "$QT5SRCDIR" == "$PWD/qt5.gitorious" ]; then
    if [ ! -d qt5.gitorious ]; then
        git clone -b release https://git.gitorious.org/qt/qt5.git qt5.gitorious
        cd qt5.gitorious
        git clone -b wip/tizen https://git.gitorious.org/qt/qtquickcontrols-tizen.git
	cd qtquickcontrols-tizen
	git reset --hard fd66e35cc0b0f0d841d8aec46e85afd6ff89444e
	cd ..
        ./init-repository --http --no-webkit --module-subset=qtactiveqt,qtbase,qtdeclarative,qtdoc,qtgraphicaleffects,qtimageformats,qtjsbackend,qtmultimedia,qtquickcontrols,qtsensors,qtserialport,qtsvg,qttools,qttranslations,qtxmlpatterns
        cd qtquickcontrols
        git checkout wip/tizen
	git reset --hard b3bff2c1d98c4a29d3ad249167409e64a836d2bf
        cd ../
        cd qtbase
        git checkout wip/tizen
	git reset --hard b2c3b3deed52cd1562f26c68eefac9ac76c24357
        cd ../qtsensors
	git checkout wip/tizen
	git reset --hard 7865efa71e8dba289c9b1ac19454f0a9311c8328
	cd ../../
    else
        echo "Looks like qt5.gitorious directory exists"
    fi;
fi;

mkdir -p buildQt5
cd buildQt5

echo "================================================="
echo "Configuration:"
echo "QT5SRCDIR=$QT5SRCDIR"
echo "INSTALLDIR=$INSTALLDIR"
echo "================================================="

$QT5SRCDIR/configure -prefix $INSTALLDIR -v \
                    -release -opensource \
                    -confirm-license -nomake examples -no-widgets

MAKE_ARGS=""

if [ "$MAKE_THREADS" != "" ]; then
    echo "setting make thread"
    MAKE_ARGS="-j $MAKE_THREADS"
fi
echo make $MAKE_ARGS

make $MAKE_ARGS
echo make install $MAKE_ARGS
make install $MAKE_ARGS

if [ -d $QT5SRCDIR/qtquickcontrols-tizen ]; then
    mkdir -p qtquickcontrols-tizen
    cd qtquickcontrols-tizen
    $INSTALLDIR/bin/qmake $QT5SRCDIR/qtquickcontrols-tizen
    make $MAKE_ARGS
    make install $MAKE_ARGS
fi

cd $CURRENT_DIR    
