import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: buttonHigh
    width: 100
    height: 100
    color: "transparent"
    property alias labelText: label.text

    Rectangle {
        id: hole
        color: "#181614"
        radius: 3
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
    }

    Rectangle {
        id: button
        radius: 9
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 3
        anchors.rightMargin: 4
        anchors.topMargin: 2
        anchors.bottomMargin: 2
        gradient: Gradient {
            id: button_Gradient
            GradientStop {
                id: button_GradientStop_0
                position: 0
                color: "#ff858585"
            }

            GradientStop {
                id: button_GradientStop_1
                position: 1
                color: "#ff6c6c6c"
            }
            orientation: Gradient.Vertical
        }
        DesignEffect {
            id: button_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
            effects: [
                DesignDropShadow {
                    id: button_DesignDropShadow_0
                    visible: true
                    color: "#6e000000"
                    spread: 0
                    offsetY: 11
                    offsetX: 8
                    blur: 18
                },
                DesignInnerShadow {
                    id: button_DesignInnerShadow_1
                    visible: true
                    color: "#7a000000"
                    spread: 0
                    offsetY: -2
                    offsetX: -2
                    blur: 3
                },
                DesignInnerShadow {
                    id: button_DesignInnerShadow_2
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 2
                    offsetX: 2
                    blur: 3
                }
            ]
        }
    }

    Text {
        id: label
        color: "#bababa"
        text: qsTr("A")
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 13
        anchors.rightMargin: 23
        anchors.topMargin: 2
        anchors.bottomMargin: 38
        font.pixelSize: 31
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.Wrap
        font.weight: Font.Bold
        font.family: "DIN Alternate"
        DesignEffect {
            id: label_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"14ba35cc-7d50-5042-beb7-876fdcfbe138"}D{i:1;uuid:"653df8f3-f6ff-52d4-884f-2e1ab763efb1"}
D{i:2;uuid:"d92673f1-c8a2-5760-bbe0-b868924f3919"}D{i:6;uuid:"d92673f1-c8a2-5760-bbe0-b868924f3919_DesignEffect"}
D{i:7;uuid:"d92673f1-c8a2-5760-bbe0-b868924f3919_DesignDropShadow_0"}D{i:8;uuid:"d92673f1-c8a2-5760-bbe0-b868924f3919_DesignInnerShadow_1"}
D{i:9;uuid:"d92673f1-c8a2-5760-bbe0-b868924f3919_DesignInnerShadow_2"}D{i:3;uuid:"d92673f1-c8a2-5760-bbe0-b868924f3919_Gradient"}
D{i:4;uuid:"d92673f1-c8a2-5760-bbe0-b868924f3919_GradientStop_0"}D{i:5;uuid:"d92673f1-c8a2-5760-bbe0-b868924f3919_GradientStop_1"}
D{i:10;uuid:"541b14fb-8968-5e8b-9580-7cf5fd91e869"}D{i:11;uuid:"541b14fb-8968-5e8b-9580-7cf5fd91e869_DesignEffect"}
}
##^##*/

