import QtQuick
import QtQuick.Controls
import QtQuick.Shapes
import QtQuick.Studio.DesignEffects 1.0
import QtQuick.Studio.Components 1.0

Rectangle {
    id: glassButton
    width: 224
    height: 277
    color: "transparent"

    Rectangle {
        id: buttonBaseFill
        radius: 103
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 16
        anchors.rightMargin: 16
        anchors.topMargin: 17
        anchors.bottomMargin: 17
        gradient: Gradient {
            id: buttonBaseFill_Gradient
            GradientStop {
                id: buttonBaseFill_GradientStop_0
                position: 1
                color: "#17ffffff"
            }

            GradientStop {
                id: buttonBaseFill_GradientStop_1
                position: 0.835
                color: "#17eb00ff"
            }

            GradientStop {
                id: buttonBaseFill_GradientStop_2
                position: 0.67
                color: "#172a122c"
            }

            GradientStop {
                id: buttonBaseFill_GradientStop_3
                position: 0.455
                color: "#172e1d3c"
            }

            GradientStop {
                id: buttonBaseFill_GradientStop_4
                position: 0.25
                color: "#17eb00ff"
            }

            GradientStop {
                id: buttonBaseFill_GradientStop_5
                position: 0
                color: "#17ffffff"
            }
            orientation: Gradient.Horizontal
        }
        DesignEffect {
            id: buttonBaseFill_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: buttonBaseFill_DesignDropShadow_0
                    visible: true
                    color: "#78000000"
                    showBehind: false
                    spread: 0
                    offsetY: 23
                    offsetX: 24
                    blur: 14.3
                }
            ]
        }
    }

    SvgPathItem {
        id: buttonBase
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 6
        anchors.rightMargin: 6
        anchors.topMargin: 8
        anchors.bottomMargin: 8
        antialiasing: true
        strokeWidth: 3
        strokeStyle: 1
        strokeColor: "transparent"
        preferredRendererType: Shape.CurveRenderer
        path: "M 209 155 L 209 106 C 209 49.11466979980469 162.8853302001953 3 106 3 C 49.11467361450195 3 3 49.11466979980469 3 106 L 3 155 C 3 211.8853302001953 49.11467361450195 258 106 258 C 162.8853302001953 258 209 211.8853302001953 209 155 Z M 106 0 C 47.45781707763672 0 0 47.45781326293945 0 106 L 0 155 C 0 213.5421905517578 47.45781707763672 261 106 261 C 164.54217529296875 261 212 213.5421905517578 212 155 L 212 106 C 212 47.45781326293945 164.54217529296875 0 106 0 Z"
        joinStyle: 0
        fillColor: "#733e41f5"
    }

    SvgPathItem {
        id: buttonInnerBase
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 10
        anchors.rightMargin: 10
        anchors.topMargin: 10
        anchors.bottomMargin: 10
        antialiasing: true
        strokeWidth: 6
        strokeStyle: 1
        strokeColor: "transparent"
        preferredRendererType: Shape.CurveRenderer
        path: "M 197.94029235839844 155.08590698242188 L 197.94029235839844 101.97016906738281 C 197.94029235839844 48.967315673828125 154.97299194335938 6 101.97014617919922 6 C 48.96729278564453 6 6 48.967247009277344 6 101.9700927734375 L 6 155.08583068847656 C 6 208.08868408203125 48.9672966003418 251.05599975585938 101.97014617919922 251.05599975585938 C 154.97300720214844 251.05599975585938 197.94029235839844 208.08876037597656 197.94029235839844 155.08590698242188 Z M 101.97014617919922 0 C 45.653587341308594 0 0 45.653533935546875 0 101.9700927734375 L 0 155.08583068847656 C 0 211.4023895263672 45.653587341308594 257.0559997558594 101.97014617919922 257.0559997558594 C 158.28671264648438 257.0559997558594 203.94029235839844 211.4024658203125 203.94029235839844 155.08590698242188 L 203.94029235839844 101.97016906738281 C 203.94029235839844 45.65361022949219 158.28671264648438 0 101.97014617919922 0 Z"
        joinStyle: 0
        fillColor: "#54000000"
        DesignEffect {
            id: buttonInnerBase_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: buttonInnerBase_DesignDropShadow_0
                    visible: true
                    color: "#fff9b5ea"
                    showBehind: false
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 2
                },
                DesignInnerShadow {
                    id: buttonInnerBase_DesignInnerShadow_1
                    visible: true
                    color: "#7dec13ff"
                    spread: 0
                    offsetY: -1
                    offsetX: 0
                    blur: 1
                }
            ]
        }
    }

    SvgPathItem {
        id: buttonBaseHighlight
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 16
        anchors.rightMargin: 16
        anchors.topMargin: 17
        anchors.bottomMargin: 17
        antialiasing: true
        strokeWidth: 6
        strokeStyle: 1
        strokeColor: "transparent"
        preferredRendererType: Shape.CurveRenderer
        path: "M 186.7960205078125 147.36192321777344 L 186.7960205078125 96.39798736572266 C 186.7960205078125 46.472564697265625 146.3234405517578 6 96.39801025390625 6 C 46.47258758544922 6 6 46.47263717651367 6 96.3980712890625 L 6 147.3620147705078 C 6 197.2874298095703 46.47258758544922 237.75999450683594 96.39801025390625 237.75999450683594 C 146.32342529296875 237.75999450683594 186.7960205078125 197.287353515625 186.7960205078125 147.36192321777344 Z M 96.39801025390625 0 C 43.15887451171875 0 0 43.158935546875 0 96.3980712890625 L 0 147.3620147705078 C 0 200.6011505126953 43.15888214111328 243.75999450683594 96.39801025390625 243.75999450683594 C 149.63714599609375 243.75999450683594 192.7960205078125 200.60105895996094 192.7960205078125 147.36192321777344 L 192.7960205078125 96.39798736572266 C 192.7960205078125 43.15885543823242 149.63714599609375 0 96.39801025390625 0 Z"
        joinStyle: 0
        fillColor: "#54000000"
        DesignEffect {
            id: buttonBaseHighlight_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: buttonBaseHighlight_DesignDropShadow_0
                    visible: true
                    color: "#fff9b5ea"
                    showBehind: false
                    spread: 0
                    offsetY: 1
                    offsetX: 0
                    blur: 2
                },
                DesignInnerShadow {
                    id: buttonBaseHighlight_DesignInnerShadow_1
                    visible: true
                    color: "#7dec13ff"
                    spread: 0
                    offsetY: -1
                    offsetX: 2
                    blur: 3.3
                },
                DesignInnerShadow {
                    id: buttonBaseHighlight_DesignInnerShadow_2
                    visible: true
                    color: "#ffffffff"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 3.5
                },
                DesignInnerShadow {
                    id: buttonBaseHighlight_DesignInnerShadow_3
                    visible: true
                    color: "#ffe791f5"
                    spread: 0
                    offsetY: 0
                    offsetX: 1
                    blur: 0
                }
            ]
        }
    }

    SvgPathItem {
        id: buttonIrisOutline
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 53
        anchors.rightMargin: 54
        anchors.topMargin: 81
        anchors.bottomMargin: 81
        antialiasing: true
        strokeWidth: 1
        strokeStyle: 1
        strokeColor: "transparent"
        preferredRendererType: Shape.CurveRenderer
        path: "M 0 57.5 C 0 25.743627548217773 25.743627548217773 0 57.5 0 L 59.5 0 C 91.25637245178223 0 117 25.743627548217773 117 57.5 L 117 57.5 C 117 89.25637245178223 91.25637245178223 115 59.5 115 L 57.5 115 C 25.743627548217773 115 0 89.25637245178223 0 57.5 L 0 57.5 Z"
        joinStyle: 0
        fillColor: "#401d3a7c"
        DesignEffect {
            id: buttonIrisOutline_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: buttonIrisOutline_DesignDropShadow_0
                    visible: true
                    color: "#992a53e5"
                    showBehind: false
                    spread: 0
                    offsetY: 12
                    offsetX: 5
                    blur: 1.8
                },
                DesignDropShadow {
                    id: buttonIrisOutline_DesignDropShadow_1
                    visible: true
                    color: "#40000000"
                    showBehind: false
                    spread: 0
                    offsetY: 3
                    offsetX: 4
                    blur: 4
                },
                DesignDropShadow {
                    id: buttonIrisOutline_DesignDropShadow_2
                    visible: true
                    color: "#ff75aafa"
                    showBehind: false
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 1
                },
                DesignInnerShadow {
                    id: buttonIrisOutline_DesignInnerShadow_3
                    visible: true
                    color: "#a63299e4"
                    spread: 0
                    offsetY: 1
                    offsetX: 2
                    blur: 3
                }
            ]
        }
    }

    SvgPathItem {
        id: buttonInner
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 86
        anchors.rightMargin: 85
        anchors.topMargin: 111
        anchors.bottomMargin: 113
        antialiasing: true
        strokeWidth: 1
        strokeStyle: 1
        strokeColor: "transparent"
        preferredRendererType: Shape.CurveRenderer
        path: "M 53 26.5 C 53 41.13554573059082 41.13554573059082 53 26.5 53 C 11.86445426940918 53 0 41.13554573059082 0 26.5 C 0 11.86445426940918 11.86445426940918 0 26.5 0 C 41.13554573059082 0 53 11.86445426940918 53 26.5 Z"
        joinStyle: 0
        fillColor: "#3b2157f9"
        DesignEffect {
            id: buttonInner_DesignEffect
            visible: true
            effects: [
                DesignDropShadow {
                    id: buttonInner_DesignDropShadow_0
                    visible: true
                    color: "#5cff35eb"
                    showBehind: false
                    spread: 0
                    offsetY: -10
                    offsetX: -11
                    blur: 16.5
                },
                DesignDropShadow {
                    id: buttonInner_DesignDropShadow_1
                    visible: true
                    color: "#63ffffff"
                    showBehind: false
                    spread: 0
                    offsetY: -10
                    offsetX: -10
                    blur: 7.7
                },
                DesignInnerShadow {
                    id: buttonInner_DesignInnerShadow_2
                    visible: true
                    color: "#63ffffff"
                    spread: 0
                    offsetY: 0
                    offsetX: 0
                    blur: 1
                },
                DesignDropShadow {
                    id: buttonInner_DesignDropShadow_3
                    visible: true
                    color: "#7a33afe5"
                    showBehind: false
                    spread: 0
                    offsetY: 3
                    offsetX: 2
                    blur: 3
                },
                DesignInnerShadow {
                    id: buttonInner_DesignInnerShadow_4
                    visible: true
                    color: "#ff00e0ff"
                    spread: 0
                    offsetY: -3
                    offsetX: -2
                    blur: 12.9
                }
            ]
        }
    }

    SvgPathItem {
        id: buttonHighlight
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 123
        anchors.rightMargin: 74
        anchors.topMargin: 123
        anchors.bottomMargin: 96
        antialiasing: true
        strokeWidth: 1
        strokeStyle: 1
        strokeColor: "transparent"
        rotation: -135.166
        preferredRendererType: Shape.CurveRenderer
        path: "M 8.911227226257324 0.5113833546638489 C 7.256944537162781 -0.5033038258552551 5.078337669372559 0.02952730655670166 4.234296798706055 1.777050256729126 C 2.128056764602661 6.137861490249634 0.7769985198974609 10.84668779373169 0.25019532442092896 15.69536018371582 C -0.40451979637145996 21.721328258514404 0.2294222116470337 27.820305347442627 2.108419418334961 33.572811126708984 C 3.987416625022888 39.32531690597534 7.06688117980957 44.59484386444092 11.135011672973633 49.01896667480469 C 14.393149852752686 52.56221675872803 18.22352695465088 55.49586272239685 22.450883865356445 57.69715881347656 C 24.18724501132965 58.60132771730423 26.268110871315002 57.71454322338104 26.9939022064209 55.896385192871094 L 26.9939022064209 55.896385192871094 C 27.706332504749298 54.11169755458832 26.841196298599243 52.101755261421204 25.15013885498047 51.18907165527344 C 21.808340311050415 49.3854638338089 18.77515959739685 47.02696180343628 16.178665161132812 44.20325469970703 C 12.793050050735474 40.52137303352356 10.2302325963974 36.1359167098999 8.66647720336914 31.3485164642334 C 7.102721810340881 26.561116218566895 6.575136721134186 21.485371589660645 7.120009422302246 16.470388412475586 C 7.541135370731354 12.594364643096924 8.595177412033081 8.825726747512817 10.231188774108887 5.318008899688721 C 11.032424747943878 3.6001055240631104 10.527053236961365 1.5024824142456055 8.911227226257324 0.5113833546638489 L 8.911227226257324 0.5113833546638489 Z"
        joinStyle: 0
        fillColor: "#ccffffff"
        DesignEffect {
            id: buttonHighlight_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 2
            effects: [
                DesignDropShadow {
                    id: buttonHighlight_DesignDropShadow_0
                    visible: true
                    color: "#942db3ff"
                    showBehind: false
                    spread: 0
                    offsetY: -2
                    offsetX: 0
                    blur: 1.3
                }
            ]
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"8c567bb8-7541-5657-8065-1ec07e9be2d5"}D{i:1;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5"}
D{i:9;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_DesignEffect"}D{i:10;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_DesignDropShadow_0"}
D{i:2;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_Gradient"}D{i:3;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_GradientStop_0"}
D{i:4;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_GradientStop_1"}D{i:5;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_GradientStop_2"}
D{i:6;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_GradientStop_3"}D{i:7;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_GradientStop_4"}
D{i:8;uuid:"f70cf36a-2e19-5072-b521-da7aa33e5cb5_GradientStop_5"}D{i:11;uuid:"96307982-0cb2-56ec-b65c-5a74a8e724d4"}
D{i:12;uuid:"4ddbf4b3-469e-5512-94ad-72c6fc91a6b2"}D{i:13;uuid:"4ddbf4b3-469e-5512-94ad-72c6fc91a6b2_DesignEffect"}
D{i:14;uuid:"4ddbf4b3-469e-5512-94ad-72c6fc91a6b2_DesignDropShadow_0"}D{i:15;uuid:"4ddbf4b3-469e-5512-94ad-72c6fc91a6b2_DesignInnerShadow_1"}
D{i:16;uuid:"fe254a60-4269-5605-a319-23ee04829188"}D{i:17;uuid:"fe254a60-4269-5605-a319-23ee04829188_DesignEffect"}
D{i:18;uuid:"fe254a60-4269-5605-a319-23ee04829188_DesignDropShadow_0"}D{i:19;uuid:"fe254a60-4269-5605-a319-23ee04829188_DesignInnerShadow_1"}
D{i:20;uuid:"fe254a60-4269-5605-a319-23ee04829188_DesignInnerShadow_2"}D{i:21;uuid:"fe254a60-4269-5605-a319-23ee04829188_DesignInnerShadow_3"}
D{i:22;uuid:"c80c31f1-ca9f-5df1-9bae-29f33d737e6a"}D{i:23;uuid:"c80c31f1-ca9f-5df1-9bae-29f33d737e6a_DesignEffect"}
D{i:24;uuid:"c80c31f1-ca9f-5df1-9bae-29f33d737e6a_DesignDropShadow_0"}D{i:25;uuid:"c80c31f1-ca9f-5df1-9bae-29f33d737e6a_DesignDropShadow_1"}
D{i:26;uuid:"c80c31f1-ca9f-5df1-9bae-29f33d737e6a_DesignDropShadow_2"}D{i:27;uuid:"c80c31f1-ca9f-5df1-9bae-29f33d737e6a_DesignInnerShadow_3"}
D{i:28;uuid:"c540da9a-3540-5c0d-9785-b5ba91190de9"}D{i:29;uuid:"c540da9a-3540-5c0d-9785-b5ba91190de9_DesignEffect"}
D{i:30;uuid:"c540da9a-3540-5c0d-9785-b5ba91190de9_DesignDropShadow_0"}D{i:31;uuid:"c540da9a-3540-5c0d-9785-b5ba91190de9_DesignDropShadow_1"}
D{i:32;uuid:"c540da9a-3540-5c0d-9785-b5ba91190de9_DesignInnerShadow_2"}D{i:33;uuid:"c540da9a-3540-5c0d-9785-b5ba91190de9_DesignDropShadow_3"}
D{i:34;uuid:"c540da9a-3540-5c0d-9785-b5ba91190de9_DesignInnerShadow_4"}D{i:35;uuid:"52a1a2d6-71d7-5f89-813d-080f99f38aab"}
D{i:36;uuid:"52a1a2d6-71d7-5f89-813d-080f99f38aab_DesignEffect"}D{i:37;uuid:"52a1a2d6-71d7-5f89-813d-080f99f38aab_DesignDropShadow_0"}
}
##^##*/

