import QtQuick 2.10
import QtQuick.Templates 2.1 as T
import highendivisystem 1.0

T.Button {
    id: control2

    font: Constants.font
    implicitWidth: graphic.width
    implicitHeight: graphic.height
    leftPadding: 4
    rightPadding: 4

    text: "My Button"
    property alias graphicMirror: graphic.mirror
    property alias graphicpressedMirror: graphicpressed.mirror
    property alias graphicpressedSource: graphicpressed.source
    property alias graphicSource: graphic.source
    property bool enabled: false

    background: buttonBackground
    Rectangle {
        id: buttonBackground
        color: "transparent"
        implicitWidth: graphic.width
        implicitHeight: graphic.height
        opacity: enabled ? 1 : 0.3
        Image {
            visible: true
            mirror: false
            id: graphic
            source: "img/plus.png"
        }
        Image {
            visible: false
            mirror: false
            id: graphicpressed
            source: "img/plus.png"
        }
    }

    states: [
        State {
            name: "normal"
            when: !control2.down && control2.enabled == false
            PropertyChanges {
                target: control2
                enabled: true
            }
            PropertyChanges {
                target: graphic
                visible: true
            }
            PropertyChanges {
                target: graphicpressed
                visible: false
            }
        },
        State {
            name: "down"
            when: control2.enabled == false
            PropertyChanges {
                target: graphicpressed
                visible: true
            }
            PropertyChanges {
                target: graphic
                visible: false
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/

